/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.paymentcryptography.AWSPaymentCryptographyAsync;
import com.amazonaws.services.paymentcryptography.AWSPaymentCryptographyAsyncClientBuilder;
import com.amazonaws.services.paymentcryptography.AWSPaymentCryptographyClient;
import com.amazonaws.services.paymentcryptography.model.CreateAliasRequest;
import com.amazonaws.services.paymentcryptography.model.CreateAliasResult;
import com.amazonaws.services.paymentcryptography.model.CreateKeyRequest;
import com.amazonaws.services.paymentcryptography.model.CreateKeyResult;
import com.amazonaws.services.paymentcryptography.model.DeleteAliasRequest;
import com.amazonaws.services.paymentcryptography.model.DeleteAliasResult;
import com.amazonaws.services.paymentcryptography.model.DeleteKeyRequest;
import com.amazonaws.services.paymentcryptography.model.DeleteKeyResult;
import com.amazonaws.services.paymentcryptography.model.ExportKeyRequest;
import com.amazonaws.services.paymentcryptography.model.ExportKeyResult;
import com.amazonaws.services.paymentcryptography.model.GetAliasRequest;
import com.amazonaws.services.paymentcryptography.model.GetAliasResult;
import com.amazonaws.services.paymentcryptography.model.GetKeyRequest;
import com.amazonaws.services.paymentcryptography.model.GetKeyResult;
import com.amazonaws.services.paymentcryptography.model.GetParametersForExportRequest;
import com.amazonaws.services.paymentcryptography.model.GetParametersForExportResult;
import com.amazonaws.services.paymentcryptography.model.GetParametersForImportRequest;
import com.amazonaws.services.paymentcryptography.model.GetParametersForImportResult;
import com.amazonaws.services.paymentcryptography.model.GetPublicKeyCertificateRequest;
import com.amazonaws.services.paymentcryptography.model.GetPublicKeyCertificateResult;
import com.amazonaws.services.paymentcryptography.model.ImportKeyRequest;
import com.amazonaws.services.paymentcryptography.model.ImportKeyResult;
import com.amazonaws.services.paymentcryptography.model.ListAliasesRequest;
import com.amazonaws.services.paymentcryptography.model.ListAliasesResult;
import com.amazonaws.services.paymentcryptography.model.ListKeysRequest;
import com.amazonaws.services.paymentcryptography.model.ListKeysResult;
import com.amazonaws.services.paymentcryptography.model.ListTagsForResourceRequest;
import com.amazonaws.services.paymentcryptography.model.ListTagsForResourceResult;
import com.amazonaws.services.paymentcryptography.model.RestoreKeyRequest;
import com.amazonaws.services.paymentcryptography.model.RestoreKeyResult;
import com.amazonaws.services.paymentcryptography.model.StartKeyUsageRequest;
import com.amazonaws.services.paymentcryptography.model.StartKeyUsageResult;
import com.amazonaws.services.paymentcryptography.model.StopKeyUsageRequest;
import com.amazonaws.services.paymentcryptography.model.StopKeyUsageResult;
import com.amazonaws.services.paymentcryptography.model.TagResourceRequest;
import com.amazonaws.services.paymentcryptography.model.TagResourceResult;
import com.amazonaws.services.paymentcryptography.model.UntagResourceRequest;
import com.amazonaws.services.paymentcryptography.model.UntagResourceResult;
import com.amazonaws.services.paymentcryptography.model.UpdateAliasRequest;
import com.amazonaws.services.paymentcryptography.model.UpdateAliasResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPaymentCryptographyAsyncClient
extends AWSPaymentCryptographyClient
implements AWSPaymentCryptographyAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPaymentCryptographyAsyncClientBuilder asyncBuilder() {
        return AWSPaymentCryptographyAsyncClientBuilder.standard();
    }

    AWSPaymentCryptographyAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPaymentCryptographyAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        final CreateAliasRequest finalRequest = (CreateAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeCreateAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(CreateKeyRequest request) {
        return this.createKeyAsync(request, null);
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(CreateKeyRequest request, final AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) {
        final CreateKeyRequest finalRequest = (CreateKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateKeyResult>(){

            @Override
            public CreateKeyResult call() throws Exception {
                CreateKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeCreateKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest request) {
        return this.deleteAliasAsync(request, null);
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest request, final AsyncHandler<DeleteAliasRequest, DeleteAliasResult> asyncHandler) {
        final DeleteAliasRequest finalRequest = (DeleteAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAliasResult>(){

            @Override
            public DeleteAliasResult call() throws Exception {
                DeleteAliasResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeDeleteAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteKeyResult> deleteKeyAsync(DeleteKeyRequest request) {
        return this.deleteKeyAsync(request, null);
    }

    @Override
    public Future<DeleteKeyResult> deleteKeyAsync(DeleteKeyRequest request, final AsyncHandler<DeleteKeyRequest, DeleteKeyResult> asyncHandler) {
        final DeleteKeyRequest finalRequest = (DeleteKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteKeyResult>(){

            @Override
            public DeleteKeyResult call() throws Exception {
                DeleteKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeDeleteKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportKeyResult> exportKeyAsync(ExportKeyRequest request) {
        return this.exportKeyAsync(request, null);
    }

    @Override
    public Future<ExportKeyResult> exportKeyAsync(ExportKeyRequest request, final AsyncHandler<ExportKeyRequest, ExportKeyResult> asyncHandler) {
        final ExportKeyRequest finalRequest = (ExportKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportKeyResult>(){

            @Override
            public ExportKeyResult call() throws Exception {
                ExportKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeExportKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAliasResult> getAliasAsync(GetAliasRequest request) {
        return this.getAliasAsync(request, null);
    }

    @Override
    public Future<GetAliasResult> getAliasAsync(GetAliasRequest request, final AsyncHandler<GetAliasRequest, GetAliasResult> asyncHandler) {
        final GetAliasRequest finalRequest = (GetAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAliasResult>(){

            @Override
            public GetAliasResult call() throws Exception {
                GetAliasResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeGetAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyResult> getKeyAsync(GetKeyRequest request) {
        return this.getKeyAsync(request, null);
    }

    @Override
    public Future<GetKeyResult> getKeyAsync(GetKeyRequest request, final AsyncHandler<GetKeyRequest, GetKeyResult> asyncHandler) {
        final GetKeyRequest finalRequest = (GetKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKeyResult>(){

            @Override
            public GetKeyResult call() throws Exception {
                GetKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeGetKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetParametersForExportResult> getParametersForExportAsync(GetParametersForExportRequest request) {
        return this.getParametersForExportAsync(request, null);
    }

    @Override
    public Future<GetParametersForExportResult> getParametersForExportAsync(GetParametersForExportRequest request, final AsyncHandler<GetParametersForExportRequest, GetParametersForExportResult> asyncHandler) {
        final GetParametersForExportRequest finalRequest = (GetParametersForExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetParametersForExportResult>(){

            @Override
            public GetParametersForExportResult call() throws Exception {
                GetParametersForExportResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeGetParametersForExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetParametersForImportResult> getParametersForImportAsync(GetParametersForImportRequest request) {
        return this.getParametersForImportAsync(request, null);
    }

    @Override
    public Future<GetParametersForImportResult> getParametersForImportAsync(GetParametersForImportRequest request, final AsyncHandler<GetParametersForImportRequest, GetParametersForImportResult> asyncHandler) {
        final GetParametersForImportRequest finalRequest = (GetParametersForImportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetParametersForImportResult>(){

            @Override
            public GetParametersForImportResult call() throws Exception {
                GetParametersForImportResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeGetParametersForImport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPublicKeyCertificateResult> getPublicKeyCertificateAsync(GetPublicKeyCertificateRequest request) {
        return this.getPublicKeyCertificateAsync(request, null);
    }

    @Override
    public Future<GetPublicKeyCertificateResult> getPublicKeyCertificateAsync(GetPublicKeyCertificateRequest request, final AsyncHandler<GetPublicKeyCertificateRequest, GetPublicKeyCertificateResult> asyncHandler) {
        final GetPublicKeyCertificateRequest finalRequest = (GetPublicKeyCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPublicKeyCertificateResult>(){

            @Override
            public GetPublicKeyCertificateResult call() throws Exception {
                GetPublicKeyCertificateResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeGetPublicKeyCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportKeyResult> importKeyAsync(ImportKeyRequest request) {
        return this.importKeyAsync(request, null);
    }

    @Override
    public Future<ImportKeyResult> importKeyAsync(ImportKeyRequest request, final AsyncHandler<ImportKeyRequest, ImportKeyResult> asyncHandler) {
        final ImportKeyRequest finalRequest = (ImportKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportKeyResult>(){

            @Override
            public ImportKeyResult call() throws Exception {
                ImportKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeImportKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest request) {
        return this.listAliasesAsync(request, null);
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest request, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        final ListAliasesRequest finalRequest = (ListAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeListAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest request) {
        return this.listKeysAsync(request, null);
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest request, final AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        final ListKeysRequest finalRequest = (ListKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                ListKeysResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeListKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreKeyResult> restoreKeyAsync(RestoreKeyRequest request) {
        return this.restoreKeyAsync(request, null);
    }

    @Override
    public Future<RestoreKeyResult> restoreKeyAsync(RestoreKeyRequest request, final AsyncHandler<RestoreKeyRequest, RestoreKeyResult> asyncHandler) {
        final RestoreKeyRequest finalRequest = (RestoreKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreKeyResult>(){

            @Override
            public RestoreKeyResult call() throws Exception {
                RestoreKeyResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeRestoreKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartKeyUsageResult> startKeyUsageAsync(StartKeyUsageRequest request) {
        return this.startKeyUsageAsync(request, null);
    }

    @Override
    public Future<StartKeyUsageResult> startKeyUsageAsync(StartKeyUsageRequest request, final AsyncHandler<StartKeyUsageRequest, StartKeyUsageResult> asyncHandler) {
        final StartKeyUsageRequest finalRequest = (StartKeyUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartKeyUsageResult>(){

            @Override
            public StartKeyUsageResult call() throws Exception {
                StartKeyUsageResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeStartKeyUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopKeyUsageResult> stopKeyUsageAsync(StopKeyUsageRequest request) {
        return this.stopKeyUsageAsync(request, null);
    }

    @Override
    public Future<StopKeyUsageResult> stopKeyUsageAsync(StopKeyUsageRequest request, final AsyncHandler<StopKeyUsageRequest, StopKeyUsageResult> asyncHandler) {
        final StopKeyUsageRequest finalRequest = (StopKeyUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopKeyUsageResult>(){

            @Override
            public StopKeyUsageResult call() throws Exception {
                StopKeyUsageResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeStopKeyUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest request) {
        return this.updateAliasAsync(request, null);
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest request, final AsyncHandler<UpdateAliasRequest, UpdateAliasResult> asyncHandler) {
        final UpdateAliasRequest finalRequest = (UpdateAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAliasResult>(){

            @Override
            public UpdateAliasResult call() throws Exception {
                UpdateAliasResult result = null;
                try {
                    result = AWSPaymentCryptographyAsyncClient.this.executeUpdateAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

