/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptography.model.KeyAttributes;
import com.amazonaws.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import com.amazonaws.services.paymentcryptography.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateKeyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Boolean enabled;
    private Boolean exportable;
    private KeyAttributes keyAttributes;
    private String keyCheckValueAlgorithm;
    private List<Tag> tags;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public CreateKeyRequest withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setExportable(Boolean exportable) {
        this.exportable = exportable;
    }

    public Boolean getExportable() {
        return this.exportable;
    }

    public CreateKeyRequest withExportable(Boolean exportable) {
        this.setExportable(exportable);
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public void setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public CreateKeyRequest withKeyAttributes(KeyAttributes keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
        this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
    }

    public String getKeyCheckValueAlgorithm() {
        return this.keyCheckValueAlgorithm;
    }

    public CreateKeyRequest withKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
        this.setKeyCheckValueAlgorithm(keyCheckValueAlgorithm);
        return this;
    }

    public CreateKeyRequest withKeyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
        this.keyCheckValueAlgorithm = keyCheckValueAlgorithm.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateKeyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateKeyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getExportable() != null) {
            sb.append("Exportable: ").append(this.getExportable()).append(",");
        }
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getKeyCheckValueAlgorithm() != null) {
            sb.append("KeyCheckValueAlgorithm: ").append(this.getKeyCheckValueAlgorithm()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest other = (CreateKeyRequest)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getExportable() == null ^ this.getExportable() == null) {
            return false;
        }
        if (other.getExportable() != null && !other.getExportable().equals(this.getExportable())) {
            return false;
        }
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getKeyCheckValueAlgorithm() == null ^ this.getKeyCheckValueAlgorithm() == null) {
            return false;
        }
        if (other.getKeyCheckValueAlgorithm() != null && !other.getKeyCheckValueAlgorithm().equals(this.getKeyCheckValueAlgorithm())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getExportable() == null ? 0 : this.getExportable().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getKeyCheckValueAlgorithm() == null ? 0 : this.getKeyCheckValueAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateKeyRequest clone() {
        return (CreateKeyRequest)super.clone();
    }
}

