/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.NetworkStatus;
import java.util.Date;

@SdkInternalApi
public class NetworkStatusMarshaller {
    private static final MarshallingInfo<StructuredPojo> ETHERNET0STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ethernet0Status").build();
    private static final MarshallingInfo<StructuredPojo> ETHERNET1STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ethernet1Status").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> NTPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NtpStatus").build();
    private static final NetworkStatusMarshaller instance = new NetworkStatusMarshaller();

    public static NetworkStatusMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkStatus networkStatus, ProtocolMarshaller protocolMarshaller) {
        if (networkStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkStatus.getEthernet0Status(), ETHERNET0STATUS_BINDING);
            protocolMarshaller.marshall((Object)networkStatus.getEthernet1Status(), ETHERNET1STATUS_BINDING);
            protocolMarshaller.marshall((Object)networkStatus.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)networkStatus.getNtpStatus(), NTPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

