/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.Address;

@SdkInternalApi
public class AddressMarshaller {
    private static final MarshallingInfo<String> CONTACTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactName").build();
    private static final MarshallingInfo<String> CONTACTPHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactPhoneNumber").build();
    private static final MarshallingInfo<String> ADDRESSLINE1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine1").build();
    private static final MarshallingInfo<String> ADDRESSLINE2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine2").build();
    private static final MarshallingInfo<String> ADDRESSLINE3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine3").build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").build();
    private static final MarshallingInfo<String> STATEORREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateOrRegion").build();
    private static final MarshallingInfo<String> DISTRICTORCOUNTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DistrictOrCounty").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").build();
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountryCode").build();
    private static final MarshallingInfo<String> MUNICIPALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Municipality").build();
    private static final AddressMarshaller instance = new AddressMarshaller();

    public static AddressMarshaller getInstance() {
        return instance;
    }

    public void marshall(Address address, ProtocolMarshaller protocolMarshaller) {
        if (address == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)address.getContactName(), CONTACTNAME_BINDING);
            protocolMarshaller.marshall((Object)address.getContactPhoneNumber(), CONTACTPHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)address.getAddressLine1(), ADDRESSLINE1_BINDING);
            protocolMarshaller.marshall((Object)address.getAddressLine2(), ADDRESSLINE2_BINDING);
            protocolMarshaller.marshall((Object)address.getAddressLine3(), ADDRESSLINE3_BINDING);
            protocolMarshaller.marshall((Object)address.getCity(), CITY_BINDING);
            protocolMarshaller.marshall((Object)address.getStateOrRegion(), STATEORREGION_BINDING);
            protocolMarshaller.marshall((Object)address.getDistrictOrCounty(), DISTRICTORCOUNTY_BINDING);
            protocolMarshaller.marshall((Object)address.getPostalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)address.getCountryCode(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)address.getMunicipality(), MUNICIPALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

