/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.Order;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class OrderMarshaller {
    private static final MarshallingInfo<String> OUTPOSTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutpostId").build();
    private static final MarshallingInfo<String> ORDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> LINEITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineItems").build();
    private static final MarshallingInfo<String> PAYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentOption").build();
    private static final MarshallingInfo<Date> ORDERSUBMISSIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderSubmissionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ORDERFULFILLEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderFulfilledDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> PAYMENTTERM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentTerm").build();
    private static final MarshallingInfo<String> ORDERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderType").build();
    private static final OrderMarshaller instance = new OrderMarshaller();

    public static OrderMarshaller getInstance() {
        return instance;
    }

    public void marshall(Order order, ProtocolMarshaller protocolMarshaller) {
        if (order == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)order.getOutpostId(), OUTPOSTID_BINDING);
            protocolMarshaller.marshall((Object)order.getOrderId(), ORDERID_BINDING);
            protocolMarshaller.marshall((Object)order.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(order.getLineItems(), LINEITEMS_BINDING);
            protocolMarshaller.marshall((Object)order.getPaymentOption(), PAYMENTOPTION_BINDING);
            protocolMarshaller.marshall((Object)order.getOrderSubmissionDate(), ORDERSUBMISSIONDATE_BINDING);
            protocolMarshaller.marshall((Object)order.getOrderFulfilledDate(), ORDERFULFILLEDDATE_BINDING);
            protocolMarshaller.marshall((Object)order.getPaymentTerm(), PAYMENTTERM_BINDING);
            protocolMarshaller.marshall((Object)order.getOrderType(), ORDERTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

