/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.ComputeAssetState;
import com.amazonaws.services.outposts.model.transform.ComputeAttributesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComputeAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String hostId;
    private String state;
    private List<String> instanceFamilies;

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public ComputeAttributes withHostId(String hostId) {
        this.setHostId(hostId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ComputeAttributes withState(String state) {
        this.setState(state);
        return this;
    }

    public ComputeAttributes withState(ComputeAssetState state) {
        this.state = state.toString();
        return this;
    }

    public List<String> getInstanceFamilies() {
        return this.instanceFamilies;
    }

    public void setInstanceFamilies(Collection<String> instanceFamilies) {
        if (instanceFamilies == null) {
            this.instanceFamilies = null;
            return;
        }
        this.instanceFamilies = new ArrayList<String>(instanceFamilies);
    }

    public ComputeAttributes withInstanceFamilies(String ... instanceFamilies) {
        if (this.instanceFamilies == null) {
            this.setInstanceFamilies(new ArrayList<String>(instanceFamilies.length));
        }
        for (String ele : instanceFamilies) {
            this.instanceFamilies.add(ele);
        }
        return this;
    }

    public ComputeAttributes withInstanceFamilies(Collection<String> instanceFamilies) {
        this.setInstanceFamilies(instanceFamilies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostId() != null) {
            sb.append("HostId: ").append(this.getHostId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getInstanceFamilies() != null) {
            sb.append("InstanceFamilies: ").append(this.getInstanceFamilies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeAttributes)) {
            return false;
        }
        ComputeAttributes other = (ComputeAttributes)obj;
        if (other.getHostId() == null ^ this.getHostId() == null) {
            return false;
        }
        if (other.getHostId() != null && !other.getHostId().equals(this.getHostId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getInstanceFamilies() == null ^ this.getInstanceFamilies() == null) {
            return false;
        }
        return other.getInstanceFamilies() == null || other.getInstanceFamilies().equals(this.getInstanceFamilies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostId() == null ? 0 : this.getHostId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamilies() == null ? 0 : this.getInstanceFamilies().hashCode());
        return hashCode;
    }

    public ComputeAttributes clone() {
        try {
            return (ComputeAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

