/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.outposts.model.CatalogItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCatalogItemsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CatalogItem> catalogItems;
    private String nextToken;

    public List<CatalogItem> getCatalogItems() {
        return this.catalogItems;
    }

    public void setCatalogItems(Collection<CatalogItem> catalogItems) {
        if (catalogItems == null) {
            this.catalogItems = null;
            return;
        }
        this.catalogItems = new ArrayList<CatalogItem>(catalogItems);
    }

    public ListCatalogItemsResult withCatalogItems(CatalogItem ... catalogItems) {
        if (this.catalogItems == null) {
            this.setCatalogItems(new ArrayList<CatalogItem>(catalogItems.length));
        }
        for (CatalogItem ele : catalogItems) {
            this.catalogItems.add(ele);
        }
        return this;
    }

    public ListCatalogItemsResult withCatalogItems(Collection<CatalogItem> catalogItems) {
        this.setCatalogItems(catalogItems);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCatalogItemsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogItems() != null) {
            sb.append("CatalogItems: ").append(this.getCatalogItems()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsResult)) {
            return false;
        }
        ListCatalogItemsResult other = (ListCatalogItemsResult)obj;
        if (other.getCatalogItems() == null ^ this.getCatalogItems() == null) {
            return false;
        }
        if (other.getCatalogItems() != null && !other.getCatalogItems().equals(this.getCatalogItems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogItems() == null ? 0 : this.getCatalogItems().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCatalogItemsResult clone() {
        try {
            return (ListCatalogItemsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

