/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.OrderSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class OrderSummaryMarshaller {
    private static final MarshallingInfo<String> OUTPOSTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutpostId").build();
    private static final MarshallingInfo<String> ORDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderId").build();
    private static final MarshallingInfo<String> ORDERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Map> LINEITEMCOUNTSBYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineItemCountsByStatus").build();
    private static final MarshallingInfo<Date> ORDERSUBMISSIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderSubmissionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ORDERFULFILLEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderFulfilledDate").timestampFormat("unixTimestamp").build();
    private static final OrderSummaryMarshaller instance = new OrderSummaryMarshaller();

    public static OrderSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(OrderSummary orderSummary, ProtocolMarshaller protocolMarshaller) {
        if (orderSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)orderSummary.getOutpostId(), OUTPOSTID_BINDING);
            protocolMarshaller.marshall((Object)orderSummary.getOrderId(), ORDERID_BINDING);
            protocolMarshaller.marshall((Object)orderSummary.getOrderType(), ORDERTYPE_BINDING);
            protocolMarshaller.marshall((Object)orderSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(orderSummary.getLineItemCountsByStatus(), LINEITEMCOUNTSBYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)orderSummary.getOrderSubmissionDate(), ORDERSUBMISSIONDATE_BINDING);
            protocolMarshaller.marshall((Object)orderSummary.getOrderFulfilledDate(), ORDERFULFILLEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

