/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.osis.model.PipelineStatus;
import com.amazonaws.services.osis.model.PipelineStatusReason;
import com.amazonaws.services.osis.model.Tag;
import com.amazonaws.services.osis.model.transform.PipelineSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PipelineSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private PipelineStatusReason statusReason;
    private String pipelineName;
    private String pipelineArn;
    private Integer minUnits;
    private Integer maxUnits;
    private Date createdAt;
    private Date lastUpdatedAt;
    private List<Tag> tags;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public PipelineSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public PipelineSummary withStatus(PipelineStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(PipelineStatusReason statusReason) {
        this.statusReason = statusReason;
    }

    public PipelineStatusReason getStatusReason() {
        return this.statusReason;
    }

    public PipelineSummary withStatusReason(PipelineStatusReason statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public PipelineSummary withPipelineName(String pipelineName) {
        this.setPipelineName(pipelineName);
        return this;
    }

    public void setPipelineArn(String pipelineArn) {
        this.pipelineArn = pipelineArn;
    }

    public String getPipelineArn() {
        return this.pipelineArn;
    }

    public PipelineSummary withPipelineArn(String pipelineArn) {
        this.setPipelineArn(pipelineArn);
        return this;
    }

    public void setMinUnits(Integer minUnits) {
        this.minUnits = minUnits;
    }

    public Integer getMinUnits() {
        return this.minUnits;
    }

    public PipelineSummary withMinUnits(Integer minUnits) {
        this.setMinUnits(minUnits);
        return this;
    }

    public void setMaxUnits(Integer maxUnits) {
        this.maxUnits = maxUnits;
    }

    public Integer getMaxUnits() {
        return this.maxUnits;
    }

    public PipelineSummary withMaxUnits(Integer maxUnits) {
        this.setMaxUnits(maxUnits);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public PipelineSummary withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public PipelineSummary withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public PipelineSummary withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public PipelineSummary withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getPipelineName() != null) {
            sb.append("PipelineName: ").append(this.getPipelineName()).append(",");
        }
        if (this.getPipelineArn() != null) {
            sb.append("PipelineArn: ").append(this.getPipelineArn()).append(",");
        }
        if (this.getMinUnits() != null) {
            sb.append("MinUnits: ").append(this.getMinUnits()).append(",");
        }
        if (this.getMaxUnits() != null) {
            sb.append("MaxUnits: ").append(this.getMaxUnits()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getPipelineName() == null ^ this.getPipelineName() == null) {
            return false;
        }
        if (other.getPipelineName() != null && !other.getPipelineName().equals(this.getPipelineName())) {
            return false;
        }
        if (other.getPipelineArn() == null ^ this.getPipelineArn() == null) {
            return false;
        }
        if (other.getPipelineArn() != null && !other.getPipelineArn().equals(this.getPipelineArn())) {
            return false;
        }
        if (other.getMinUnits() == null ^ this.getMinUnits() == null) {
            return false;
        }
        if (other.getMinUnits() != null && !other.getMinUnits().equals(this.getMinUnits())) {
            return false;
        }
        if (other.getMaxUnits() == null ^ this.getMaxUnits() == null) {
            return false;
        }
        if (other.getMaxUnits() != null && !other.getMaxUnits().equals(this.getMaxUnits())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineName() == null ? 0 : this.getPipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineArn() == null ? 0 : this.getPipelineArn().hashCode());
        hashCode = 31 * hashCode + (this.getMinUnits() == null ? 0 : this.getMinUnits().hashCode());
        hashCode = 31 * hashCode + (this.getMaxUnits() == null ? 0 : this.getMaxUnits().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PipelineSummary clone() {
        try {
            return (PipelineSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

