/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.osis.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.osis.model.PipelineSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPipelinesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<PipelineSummary> pipelines;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPipelinesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<PipelineSummary> getPipelines() {
        return this.pipelines;
    }

    public void setPipelines(Collection<PipelineSummary> pipelines) {
        if (pipelines == null) {
            this.pipelines = null;
            return;
        }
        this.pipelines = new ArrayList<PipelineSummary>(pipelines);
    }

    public ListPipelinesResult withPipelines(PipelineSummary ... pipelines) {
        if (this.pipelines == null) {
            this.setPipelines(new ArrayList<PipelineSummary>(pipelines.length));
        }
        for (PipelineSummary ele : pipelines) {
            this.pipelines.add(ele);
        }
        return this;
    }

    public ListPipelinesResult withPipelines(Collection<PipelineSummary> pipelines) {
        this.setPipelines(pipelines);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPipelines() != null) {
            sb.append("Pipelines: ").append(this.getPipelines());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResult)) {
            return false;
        }
        ListPipelinesResult other = (ListPipelinesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPipelines() == null ^ this.getPipelines() == null) {
            return false;
        }
        return other.getPipelines() == null || other.getPipelines().equals(this.getPipelines());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPipelines() == null ? 0 : this.getPipelines().hashCode());
        return hashCode;
    }

    public ListPipelinesResult clone() {
        try {
            return (ListPipelinesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

