/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import com.amazonaws.services.route53.model.VPC;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class DisassociateVPCFromHostedZoneRequestMarshaller
implements Marshaller<Request<DisassociateVPCFromHostedZoneRequest>, DisassociateVPCFromHostedZoneRequest> {
    @Override
    public Request<DisassociateVPCFromHostedZoneRequest> marshall(DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) {
        VPC vPCVPC;
        if (disassociateVPCFromHostedZoneRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisassociateVPCFromHostedZoneRequest> request = new DefaultRequest<DisassociateVPCFromHostedZoneRequest>(disassociateVPCFromHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/disassociatevpc";
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(disassociateVPCFromHostedZoneRequest.getHostedZoneId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("DisassociateVPCFromHostedZoneRequest");
        if (disassociateVPCFromHostedZoneRequest != null && (vPCVPC = disassociateVPCFromHostedZoneRequest.getVPC()) != null) {
            xmlWriter.startElement("VPC");
            if (vPCVPC.getVPCRegion() != null) {
                xmlWriter.startElement("VPCRegion").value(vPCVPC.getVPCRegion()).endElement();
            }
            if (vPCVPC.getVPCId() != null) {
                xmlWriter.startElement("VPCId").value(vPCVPC.getVPCId()).endElement();
            }
            xmlWriter.endElement();
        }
        if (disassociateVPCFromHostedZoneRequest.getComment() != null) {
            xmlWriter.startElement("Comment").value(disassociateVPCFromHostedZoneRequest.getComment()).endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

