/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UpdateFunctionConfigurationRequestMarshaller
implements Marshaller<Request<UpdateFunctionConfigurationRequest>, UpdateFunctionConfigurationRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<UpdateFunctionConfigurationRequest> marshall(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        String value;
        String name;
        if (updateFunctionConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFunctionConfigurationRequest> request = new DefaultRequest<UpdateFunctionConfigurationRequest>(updateFunctionConfigurationRequest, "AWSLambda");
        String target = "AWSLambda.UpdateFunctionConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("FunctionName")) {
            name = DYNAMIC_QUERY_PARAMS.get("FunctionName");
            String string = value = updateFunctionConfigurationRequest.getFunctionName() == null ? null : StringUtils.fromString(updateFunctionConfigurationRequest.getFunctionName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionConfigurationRequest.getFunctionName() == null ? "" : StringUtils.fromString(updateFunctionConfigurationRequest.getFunctionName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Role")) {
            name = DYNAMIC_QUERY_PARAMS.get("Role");
            String string = value = updateFunctionConfigurationRequest.getRole() == null ? null : StringUtils.fromString(updateFunctionConfigurationRequest.getRole());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Role}", updateFunctionConfigurationRequest.getRole() == null ? "" : StringUtils.fromString(updateFunctionConfigurationRequest.getRole()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Handler")) {
            name = DYNAMIC_QUERY_PARAMS.get("Handler");
            String string = value = updateFunctionConfigurationRequest.getHandler() == null ? null : StringUtils.fromString(updateFunctionConfigurationRequest.getHandler());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Handler}", updateFunctionConfigurationRequest.getHandler() == null ? "" : StringUtils.fromString(updateFunctionConfigurationRequest.getHandler()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Description")) {
            name = DYNAMIC_QUERY_PARAMS.get("Description");
            String string = value = updateFunctionConfigurationRequest.getDescription() == null ? null : StringUtils.fromString(updateFunctionConfigurationRequest.getDescription());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Description}", updateFunctionConfigurationRequest.getDescription() == null ? "" : StringUtils.fromString(updateFunctionConfigurationRequest.getDescription()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Timeout")) {
            name = DYNAMIC_QUERY_PARAMS.get("Timeout");
            String string = value = updateFunctionConfigurationRequest.getTimeout() == null ? null : StringUtils.fromInteger(updateFunctionConfigurationRequest.getTimeout());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Timeout}", updateFunctionConfigurationRequest.getTimeout() == null ? "" : StringUtils.fromInteger(updateFunctionConfigurationRequest.getTimeout()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MemorySize")) {
            name = DYNAMIC_QUERY_PARAMS.get("MemorySize");
            String string = value = updateFunctionConfigurationRequest.getMemorySize() == null ? null : StringUtils.fromInteger(updateFunctionConfigurationRequest.getMemorySize());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MemorySize}", updateFunctionConfigurationRequest.getMemorySize() == null ? "" : StringUtils.fromInteger(updateFunctionConfigurationRequest.getMemorySize()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }

    static {
        String path = "/2014-11-13/functions/{FunctionName}/configuration?Description={Description}&Handler={Handler}&MemorySize={MemorySize}&Role={Role}&Timeout={Timeout}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

