/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.PortMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerDefinition
implements Serializable {
    private String name;
    private String image;
    private Integer cpu;
    private Integer memory;
    private ListWithAutoConstructFlag<String> links;
    private ListWithAutoConstructFlag<PortMapping> portMappings;
    private Boolean essential;
    private ListWithAutoConstructFlag<String> entryPoint;
    private ListWithAutoConstructFlag<String> command;
    private ListWithAutoConstructFlag<KeyValuePair> environment;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ContainerDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public ContainerDefinition withCpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public ContainerDefinition withMemory(Integer memory) {
        this.memory = memory;
        return this;
    }

    public List<String> getLinks() {
        if (this.links == null) {
            this.links = new ListWithAutoConstructFlag();
            this.links.setAutoConstruct(true);
        }
        return this.links;
    }

    public void setLinks(Collection<String> links) {
        if (links == null) {
            this.links = null;
            return;
        }
        ListWithAutoConstructFlag linksCopy = new ListWithAutoConstructFlag(links.size());
        linksCopy.addAll(links);
        this.links = linksCopy;
    }

    public ContainerDefinition withLinks(String ... links) {
        if (this.getLinks() == null) {
            this.setLinks(new ArrayList<String>(links.length));
        }
        for (String value : links) {
            this.getLinks().add(value);
        }
        return this;
    }

    public ContainerDefinition withLinks(Collection<String> links) {
        if (links == null) {
            this.links = null;
        } else {
            ListWithAutoConstructFlag linksCopy = new ListWithAutoConstructFlag(links.size());
            linksCopy.addAll(links);
            this.links = linksCopy;
        }
        return this;
    }

    public List<PortMapping> getPortMappings() {
        if (this.portMappings == null) {
            this.portMappings = new ListWithAutoConstructFlag();
            this.portMappings.setAutoConstruct(true);
        }
        return this.portMappings;
    }

    public void setPortMappings(Collection<PortMapping> portMappings) {
        if (portMappings == null) {
            this.portMappings = null;
            return;
        }
        ListWithAutoConstructFlag portMappingsCopy = new ListWithAutoConstructFlag(portMappings.size());
        portMappingsCopy.addAll(portMappings);
        this.portMappings = portMappingsCopy;
    }

    public ContainerDefinition withPortMappings(PortMapping ... portMappings) {
        if (this.getPortMappings() == null) {
            this.setPortMappings(new ArrayList<PortMapping>(portMappings.length));
        }
        for (PortMapping value : portMappings) {
            this.getPortMappings().add(value);
        }
        return this;
    }

    public ContainerDefinition withPortMappings(Collection<PortMapping> portMappings) {
        if (portMappings == null) {
            this.portMappings = null;
        } else {
            ListWithAutoConstructFlag portMappingsCopy = new ListWithAutoConstructFlag(portMappings.size());
            portMappingsCopy.addAll(portMappings);
            this.portMappings = portMappingsCopy;
        }
        return this;
    }

    public Boolean isEssential() {
        return this.essential;
    }

    public void setEssential(Boolean essential) {
        this.essential = essential;
    }

    public ContainerDefinition withEssential(Boolean essential) {
        this.essential = essential;
        return this;
    }

    public Boolean getEssential() {
        return this.essential;
    }

    public List<String> getEntryPoint() {
        if (this.entryPoint == null) {
            this.entryPoint = new ListWithAutoConstructFlag();
            this.entryPoint.setAutoConstruct(true);
        }
        return this.entryPoint;
    }

    public void setEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
            return;
        }
        ListWithAutoConstructFlag entryPointCopy = new ListWithAutoConstructFlag(entryPoint.size());
        entryPointCopy.addAll(entryPoint);
        this.entryPoint = entryPointCopy;
    }

    public ContainerDefinition withEntryPoint(String ... entryPoint) {
        if (this.getEntryPoint() == null) {
            this.setEntryPoint(new ArrayList<String>(entryPoint.length));
        }
        for (String value : entryPoint) {
            this.getEntryPoint().add(value);
        }
        return this;
    }

    public ContainerDefinition withEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
        } else {
            ListWithAutoConstructFlag entryPointCopy = new ListWithAutoConstructFlag(entryPoint.size());
            entryPointCopy.addAll(entryPoint);
            this.entryPoint = entryPointCopy;
        }
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new ListWithAutoConstructFlag();
            this.command.setAutoConstruct(true);
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
        commandCopy.addAll(command);
        this.command = commandCopy;
    }

    public ContainerDefinition withCommand(String ... command) {
        if (this.getCommand() == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String value : command) {
            this.getCommand().add(value);
        }
        return this;
    }

    public ContainerDefinition withCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
        } else {
            ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
            commandCopy.addAll(command);
            this.command = commandCopy;
        }
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        if (this.environment == null) {
            this.environment = new ListWithAutoConstructFlag();
            this.environment.setAutoConstruct(true);
        }
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
        environmentCopy.addAll(environment);
        this.environment = environmentCopy;
    }

    public ContainerDefinition withEnvironment(KeyValuePair ... environment) {
        if (this.getEnvironment() == null) {
            this.setEnvironment(new ArrayList<KeyValuePair>(environment.length));
        }
        for (KeyValuePair value : environment) {
            this.getEnvironment().add(value);
        }
        return this;
    }

    public ContainerDefinition withEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
        } else {
            ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
            environmentCopy.addAll(environment);
            this.environment = environmentCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getImage() != null) {
            sb.append("Image: " + this.getImage() + ",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: " + this.getCpu() + ",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: " + this.getMemory() + ",");
        }
        if (this.getLinks() != null) {
            sb.append("Links: " + this.getLinks() + ",");
        }
        if (this.getPortMappings() != null) {
            sb.append("PortMappings: " + this.getPortMappings() + ",");
        }
        if (this.isEssential() != null) {
            sb.append("Essential: " + this.isEssential() + ",");
        }
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: " + this.getEntryPoint() + ",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: " + this.getCommand() + ",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: " + this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getLinks() == null ? 0 : this.getLinks().hashCode());
        hashCode = 31 * hashCode + (this.getPortMappings() == null ? 0 : this.getPortMappings().hashCode());
        hashCode = 31 * hashCode + (this.isEssential() == null ? 0 : this.isEssential().hashCode());
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getLinks() == null ^ this.getLinks() == null) {
            return false;
        }
        if (other.getLinks() != null && !other.getLinks().equals(this.getLinks())) {
            return false;
        }
        if (other.getPortMappings() == null ^ this.getPortMappings() == null) {
            return false;
        }
        if (other.getPortMappings() != null && !other.getPortMappings().equals(this.getPortMappings())) {
            return false;
        }
        if (other.isEssential() == null ^ this.isEssential() == null) {
            return false;
        }
        if (other.isEssential() != null && !other.isEssential().equals(this.isEssential())) {
            return false;
        }
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }
}

