/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.InstanceStatus;
import com.amazonaws.services.codedeploy.model.LifecycleEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InstanceSummary
implements Serializable {
    private String deploymentId;
    private String instanceId;
    private String status;
    private Date lastUpdatedAt;
    private ListWithAutoConstructFlag<LifecycleEvent> lifecycleEvents;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public InstanceSummary withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public InstanceSummary withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public InstanceSummary withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status.toString();
    }

    public InstanceSummary withStatus(InstanceStatus status) {
        this.status = status.toString();
        return this;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public InstanceSummary withLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    public List<LifecycleEvent> getLifecycleEvents() {
        if (this.lifecycleEvents == null) {
            this.lifecycleEvents = new ListWithAutoConstructFlag();
            this.lifecycleEvents.setAutoConstruct(true);
        }
        return this.lifecycleEvents;
    }

    public void setLifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
        if (lifecycleEvents == null) {
            this.lifecycleEvents = null;
            return;
        }
        ListWithAutoConstructFlag lifecycleEventsCopy = new ListWithAutoConstructFlag(lifecycleEvents.size());
        lifecycleEventsCopy.addAll(lifecycleEvents);
        this.lifecycleEvents = lifecycleEventsCopy;
    }

    public InstanceSummary withLifecycleEvents(LifecycleEvent ... lifecycleEvents) {
        if (this.getLifecycleEvents() == null) {
            this.setLifecycleEvents(new ArrayList<LifecycleEvent>(lifecycleEvents.length));
        }
        for (LifecycleEvent value : lifecycleEvents) {
            this.getLifecycleEvents().add(value);
        }
        return this;
    }

    public InstanceSummary withLifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
        if (lifecycleEvents == null) {
            this.lifecycleEvents = null;
        } else {
            ListWithAutoConstructFlag lifecycleEventsCopy = new ListWithAutoConstructFlag(lifecycleEvents.size());
            lifecycleEventsCopy.addAll(lifecycleEvents);
            this.lifecycleEvents = lifecycleEventsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: " + this.getDeploymentId() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: " + this.getLastUpdatedAt() + ",");
        }
        if (this.getLifecycleEvents() != null) {
            sb.append("LifecycleEvents: " + this.getLifecycleEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleEvents() == null ? 0 : this.getLifecycleEvents().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getLifecycleEvents() == null ^ this.getLifecycleEvents() == null) {
            return false;
        }
        return other.getLifecycleEvents() == null || other.getLifecycleEvents().equals(this.getLifecycleEvents());
    }
}

