/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ResultConverter;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveQueueBuffer {
    private static Log log = LogFactory.getLog(ReceiveQueueBuffer.class);
    private final QueueBufferConfig config;
    private final String qUrl;
    private final Executor executor;
    private final AmazonSQS sqsClient;
    private long bufferCounter = 0L;
    private volatile long visibilityTimeoutNanos = -1L;
    private volatile int inflightReceiveMessageBatches;
    private final Object taskSpawnSyncPoint = new Object();
    volatile boolean shutDown = false;
    private final LinkedList<ReceiveMessageFuture> futures = new LinkedList();
    private LinkedList<ReceiveMessageBatchTask> finishedTasks = new LinkedList();

    ReceiveQueueBuffer(AmazonSQS paramSQS, Executor paramExecutor, QueueBufferConfig paramConfig, String url) {
        this.config = paramConfig;
        this.executor = paramExecutor;
        this.sqsClient = paramSQS;
        this.qUrl = url;
    }

    public void shutdown() {
        this.shutDown = true;
        try {
            while (this.inflightReceiveMessageBatches > 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest rq, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback) {
        if (this.shutDown) {
            throw new AmazonClientException("The client has been shut down.");
        }
        int numMessages = 10;
        if (rq.getMaxNumberOfMessages() != null) {
            numMessages = rq.getMaxNumberOfMessages();
        }
        ReceiveMessageFuture toReturn = this.issueFuture(numMessages, callback);
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveMessageFuture issueFuture(int size, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback) {
        LinkedList<ReceiveMessageFuture> linkedList = this.futures;
        synchronized (linkedList) {
            ReceiveMessageFuture theFuture = new ReceiveMessageFuture(callback, size);
            this.futures.addLast(theFuture);
            return theFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void satisfyFuturesFromBuffer() {
        LinkedList<ReceiveMessageFuture> linkedList = this.futures;
        synchronized (linkedList) {
            LinkedList<ReceiveMessageBatchTask> linkedList2 = this.finishedTasks;
            synchronized (linkedList2) {
                while (!this.futures.isEmpty() && !this.finishedTasks.isEmpty()) {
                    ReceiveMessageFuture currentFuture = this.futures.poll();
                    this.fillFuture(currentFuture);
                }
            }
        }
    }

    private void fillFuture(ReceiveMessageFuture f) {
        ReceiveMessageBatchTask t;
        ReceiveMessageResult r = new ReceiveMessageResult();
        LinkedList<Message> messages = new LinkedList<Message>();
        r.setMessages(messages);
        Exception exception = null;
        if (!this.finishedTasks.isEmpty()) {
            t = this.finishedTasks.getFirst();
            exception = t.getException();
            boolean batchDone = false;
            for (int retrieved = 0; retrieved < f.getRequestedSize(); ++retrieved) {
                Message m = t.removeMessage();
                if (null != m) {
                    messages.add(m);
                    continue;
                }
                batchDone = true;
                break;
            }
            boolean bl = batchDone = batchDone || t.isEmpty() || exception != null;
            if (batchDone) {
                this.finishedTasks.removeFirst();
            }
            r.setMessages(messages);
        }
        if (exception != null) {
            f.setFailure(exception);
        } else {
            f.setSuccess(r);
        }
        while (!this.finishedTasks.isEmpty() && (t = this.finishedTasks.getFirst()).isEmpty() && t.getException() == null) {
            this.finishedTasks.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnMoreReceiveTasks() {
        if (this.shutDown) {
            return;
        }
        int desiredBatches = this.config.getMaxDoneReceiveBatches();
        desiredBatches = desiredBatches < 1 ? 1 : desiredBatches;
        Object object = this.finishedTasks;
        synchronized (object) {
            if (this.finishedTasks.size() >= desiredBatches) {
                return;
            }
            if (this.finishedTasks.size() > 0 && this.finishedTasks.size() + this.inflightReceiveMessageBatches >= desiredBatches) {
                return;
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            int max;
            int toSpawn;
            if (this.visibilityTimeoutNanos == -1L) {
                GetQueueAttributesRequest request = new GetQueueAttributesRequest().withQueueUrl(this.qUrl).withAttributeNames("VisibilityTimeout");
                ResultConverter.appendUserAgent(request, AmazonSQSBufferedAsyncClient.USER_AGENT);
                long visibilityTimeoutSeconds = Long.parseLong(this.sqsClient.getQueueAttributes(request).getAttributes().get("VisibilityTimeout"));
                this.visibilityTimeoutNanos = TimeUnit.NANOSECONDS.convert(visibilityTimeoutSeconds, TimeUnit.SECONDS);
            }
            if ((toSpawn = (max = (max = this.config.getMaxInflightReceiveBatches()) > 0 ? max : 1) - this.inflightReceiveMessageBatches) > 0) {
                ReceiveMessageBatchTask task = new ReceiveMessageBatchTask(this);
                ++this.inflightReceiveMessageBatches;
                ++this.bufferCounter;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spawned receive batch #" + this.bufferCounter + " (" + this.inflightReceiveMessageBatches + " of " + max + " inflight) for queue " + this.qUrl));
                }
                this.executor.execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBatchFinished(ReceiveMessageBatchTask batch) {
        Object object = this.finishedTasks;
        synchronized (object) {
            this.finishedTasks.addLast(batch);
            if (log.isTraceEnabled()) {
                log.info((Object)("Queue " + this.qUrl + " now has " + this.finishedTasks.size() + " receive results cached "));
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            --this.inflightReceiveMessageBatches;
        }
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean done = false;
        while (!done) {
            ReceiveMessageBatchTask currentBatch = null;
            LinkedList<ReceiveMessageBatchTask> linkedList = this.finishedTasks;
            synchronized (linkedList) {
                currentBatch = this.finishedTasks.poll();
            }
            if (currentBatch != null) {
                currentBatch.clear();
                continue;
            }
            done = true;
        }
    }

    private class ReceiveMessageBatchTask
    implements Runnable {
        private Exception exception = null;
        private List<Message> messages;
        private long visibilityDeadlineNano;
        private boolean open = false;
        private ReceiveQueueBuffer parentBuffer;

        ReceiveMessageBatchTask(ReceiveQueueBuffer paramParentBuffer) {
            this.parentBuffer = paramParentBuffer;
            this.messages = Collections.emptyList();
        }

        synchronized int getSize() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.messages.size();
        }

        synchronized boolean isEmpty() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.messages.isEmpty();
        }

        synchronized Exception getException() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.exception;
        }

        synchronized Message removeMessage() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (System.nanoTime() > this.visibilityDeadlineNano) {
                this.messages.clear();
                return null;
            }
            if (this.messages.isEmpty()) {
                return null;
            }
            return this.messages.remove(this.messages.size() - 1);
        }

        synchronized void clear() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (System.nanoTime() < this.visibilityDeadlineNano) {
                ChangeMessageVisibilityBatchRequest batchRequest = new ChangeMessageVisibilityBatchRequest().withQueueUrl(ReceiveQueueBuffer.this.qUrl);
                ResultConverter.appendUserAgent(batchRequest, AmazonSQSBufferedAsyncClient.USER_AGENT);
                ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(this.messages.size());
                int i = 0;
                for (Message m : this.messages) {
                    entries.add(new ChangeMessageVisibilityBatchRequestEntry().withId(Integer.toString(i)).withReceiptHandle(m.getReceiptHandle()).withVisibilityTimeout(0));
                    ++i;
                }
                try {
                    batchRequest.setEntries(entries);
                    ReceiveQueueBuffer.this.sqsClient.changeMessageVisibilityBatch(batchRequest);
                }
                catch (AmazonClientException e) {
                    log.warn((Object)("ReceiveMessageBatchTask: changeMessageVisibility failed " + e));
                }
            }
            this.messages.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.visibilityDeadlineNano = System.nanoTime() + ReceiveQueueBuffer.this.visibilityTimeoutNanos;
                ReceiveMessageRequest request = new ReceiveMessageRequest(ReceiveQueueBuffer.this.qUrl).withMaxNumberOfMessages(ReceiveQueueBuffer.this.config.getMaxBatchSize());
                ResultConverter.appendUserAgent(request, AmazonSQSBufferedAsyncClient.USER_AGENT);
                if (ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds() > 0) {
                    request.setVisibilityTimeout(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds());
                    this.visibilityDeadlineNano = System.nanoTime() + TimeUnit.NANOSECONDS.convert(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds(), TimeUnit.SECONDS);
                }
                if (ReceiveQueueBuffer.this.config.isLongPoll()) {
                    request.withWaitTimeSeconds(ReceiveQueueBuffer.this.config.getLongPollWaitTimeoutSeconds());
                }
                this.messages = ReceiveQueueBuffer.this.sqsClient.receiveMessage(request).getMessages();
            }
            catch (AmazonClientException e) {
                this.exception = e;
            }
            finally {
                this.open = true;
                this.parentBuffer.reportBatchFinished(this);
            }
        }
    }

    private class ReceiveMessageFuture
    extends QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> {
        private int requestedSize;

        ReceiveMessageFuture(int paramSize) {
            this(null, paramSize);
        }

        ReceiveMessageFuture(QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> cb, int paramSize) {
            super(cb);
            this.requestedSize = paramSize;
        }

        public int getRequestedSize() {
            return this.requestedSize;
        }
    }
}

