/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutAttributesRequestMarshaller
implements Marshaller<Request<PutAttributesRequest>, PutAttributesRequest> {
    @Override
    public Request<PutAttributesRequest> marshall(PutAttributesRequest putAttributesRequest) {
        if (putAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutAttributesRequest> request = new DefaultRequest<PutAttributesRequest>(putAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "PutAttributes");
        request.addParameter("Version", "2009-04-15");
        if (putAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(putAttributesRequest.getDomainName()));
        }
        if (putAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(putAttributesRequest.getItemName()));
        }
        List<ReplaceableAttribute> attributesList = putAttributesRequest.getAttributes();
        int attributesListIndex = 1;
        for (ReplaceableAttribute attributesListValue : attributesList) {
            ReplaceableAttribute replaceableAttributeMember = attributesListValue;
            if (replaceableAttributeMember != null) {
                if (replaceableAttributeMember.getName() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(replaceableAttributeMember.getName()));
                }
                if (replaceableAttributeMember.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(replaceableAttributeMember.getValue()));
                }
                if (replaceableAttributeMember.isReplace() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean(replaceableAttributeMember.isReplace()));
                }
            }
            ++attributesListIndex;
        }
        UpdateCondition updateConditionExpected = putAttributesRequest.getExpected();
        if (updateConditionExpected != null) {
            if (updateConditionExpected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(updateConditionExpected.getName()));
            }
            if (updateConditionExpected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(updateConditionExpected.getValue()));
            }
            if (updateConditionExpected.isExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(updateConditionExpected.isExists()));
            }
        }
        return request;
    }
}

