/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.CreateAppRequest;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class CreateAppRequestMarshaller
implements Marshaller<Request<CreateAppRequest>, CreateAppRequest> {
    @Override
    public Request<CreateAppRequest> marshall(CreateAppRequest createAppRequest) {
        if (createAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAppRequest> request = new DefaultRequest<CreateAppRequest>(createAppRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateApp";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag environmentList;
            SslConfiguration sslConfiguration;
            ListWithAutoConstructFlag domainsList;
            Source appSource;
            ListWithAutoConstructFlag dataSourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAppRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createAppRequest.getStackId());
            }
            if (createAppRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value(createAppRequest.getShortname());
            }
            if (createAppRequest.getName() != null) {
                jsonWriter.key("Name").value(createAppRequest.getName());
            }
            if (createAppRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createAppRequest.getDescription());
            }
            if (!((dataSourcesList = (ListWithAutoConstructFlag)createAppRequest.getDataSources()) == null || dataSourcesList.isAutoConstruct() && dataSourcesList.isEmpty())) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    jsonWriter.object();
                    if (dataSourcesListValue.getType() != null) {
                        jsonWriter.key("Type").value(dataSourcesListValue.getType());
                    }
                    if (dataSourcesListValue.getArn() != null) {
                        jsonWriter.key("Arn").value(dataSourcesListValue.getArn());
                    }
                    if (dataSourcesListValue.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value(dataSourcesListValue.getDatabaseName());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.getType() != null) {
                jsonWriter.key("Type").value(createAppRequest.getType());
            }
            if ((appSource = createAppRequest.getAppSource()) != null) {
                jsonWriter.key("AppSource");
                jsonWriter.object();
                if (appSource.getType() != null) {
                    jsonWriter.key("Type").value(appSource.getType());
                }
                if (appSource.getUrl() != null) {
                    jsonWriter.key("Url").value(appSource.getUrl());
                }
                if (appSource.getUsername() != null) {
                    jsonWriter.key("Username").value(appSource.getUsername());
                }
                if (appSource.getPassword() != null) {
                    jsonWriter.key("Password").value(appSource.getPassword());
                }
                if (appSource.getSshKey() != null) {
                    jsonWriter.key("SshKey").value(appSource.getSshKey());
                }
                if (appSource.getRevision() != null) {
                    jsonWriter.key("Revision").value(appSource.getRevision());
                }
                jsonWriter.endObject();
            }
            if (!((domainsList = (ListWithAutoConstructFlag)createAppRequest.getDomains()) == null || domainsList.isAutoConstruct() && domainsList.isEmpty())) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value(domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.isEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value(createAppRequest.isEnableSsl());
            }
            if ((sslConfiguration = createAppRequest.getSslConfiguration()) != null) {
                jsonWriter.key("SslConfiguration");
                jsonWriter.object();
                if (sslConfiguration.getCertificate() != null) {
                    jsonWriter.key("Certificate").value(sslConfiguration.getCertificate());
                }
                if (sslConfiguration.getPrivateKey() != null) {
                    jsonWriter.key("PrivateKey").value(sslConfiguration.getPrivateKey());
                }
                if (sslConfiguration.getChain() != null) {
                    jsonWriter.key("Chain").value(sslConfiguration.getChain());
                }
                jsonWriter.endObject();
            }
            if (createAppRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : createAppRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((environmentList = (ListWithAutoConstructFlag)createAppRequest.getEnvironment()) == null || environmentList.isAutoConstruct() && environmentList.isEmpty())) {
                jsonWriter.key("Environment");
                jsonWriter.array();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    jsonWriter.object();
                    if (environmentListValue.getKey() != null) {
                        jsonWriter.key("Key").value(environmentListValue.getKey());
                    }
                    if (environmentListValue.getValue() != null) {
                        jsonWriter.key("Value").value(environmentListValue.getValue());
                    }
                    if (environmentListValue.isSecure() != null) {
                        jsonWriter.key("Secure").value(environmentListValue.isSecure());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

