/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.ListDeploymentsRequest;
import com.amazonaws.services.codedeploy.model.TimeRange;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListDeploymentsRequestMarshaller
implements Marshaller<Request<ListDeploymentsRequest>, ListDeploymentsRequest> {
    @Override
    public Request<ListDeploymentsRequest> marshall(ListDeploymentsRequest listDeploymentsRequest) {
        if (listDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDeploymentsRequest> request = new DefaultRequest<ListDeploymentsRequest>(listDeploymentsRequest, "AmazonCodeDeploy");
        String target = "CodeDeploy_20141006.ListDeployments";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            TimeRange createTimeRange;
            ListWithAutoConstructFlag includeOnlyStatusesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listDeploymentsRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(listDeploymentsRequest.getApplicationName());
            }
            if (listDeploymentsRequest.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value(listDeploymentsRequest.getDeploymentGroupName());
            }
            if (!((includeOnlyStatusesList = (ListWithAutoConstructFlag)listDeploymentsRequest.getIncludeOnlyStatuses()) == null || includeOnlyStatusesList.isAutoConstruct() && includeOnlyStatusesList.isEmpty())) {
                jsonWriter.key("includeOnlyStatuses");
                jsonWriter.array();
                for (String includeOnlyStatusesListValue : includeOnlyStatusesList) {
                    if (includeOnlyStatusesListValue == null) continue;
                    jsonWriter.value(includeOnlyStatusesListValue);
                }
                jsonWriter.endArray();
            }
            if ((createTimeRange = listDeploymentsRequest.getCreateTimeRange()) != null) {
                jsonWriter.key("createTimeRange");
                jsonWriter.object();
                if (createTimeRange.getStart() != null) {
                    jsonWriter.key("start").value(createTimeRange.getStart());
                }
                if (createTimeRange.getEnd() != null) {
                    jsonWriter.key("end").value(createTimeRange.getEnd());
                }
                jsonWriter.endObject();
            }
            if (listDeploymentsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listDeploymentsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

