/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transfer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies the details for the S3 file being copied.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/S3InputFileLocation" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class S3InputFileLocation implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies the S3 bucket that contains the file being copied.
     * </p>
     */
    private String bucket;
    /**
     * <p>
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * </p>
     */
    private String key;

    /**
     * <p>
     * Specifies the S3 bucket that contains the file being copied.
     * </p>
     * 
     * @param bucket
     *        Specifies the S3 bucket that contains the file being copied.
     */

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    /**
     * <p>
     * Specifies the S3 bucket that contains the file being copied.
     * </p>
     * 
     * @return Specifies the S3 bucket that contains the file being copied.
     */

    public String getBucket() {
        return this.bucket;
    }

    /**
     * <p>
     * Specifies the S3 bucket that contains the file being copied.
     * </p>
     * 
     * @param bucket
     *        Specifies the S3 bucket that contains the file being copied.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3InputFileLocation withBucket(String bucket) {
        setBucket(bucket);
        return this;
    }

    /**
     * <p>
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * </p>
     * 
     * @param key
     *        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * </p>
     * 
     * @return The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */

    public String getKey() {
        return this.key;
    }

    /**
     * <p>
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * </p>
     * 
     * @param key
     *        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public S3InputFileLocation withKey(String key) {
        setKey(key);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBucket() != null)
            sb.append("Bucket: ").append(getBucket()).append(",");
        if (getKey() != null)
            sb.append("Key: ").append(getKey());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof S3InputFileLocation == false)
            return false;
        S3InputFileLocation other = (S3InputFileLocation) obj;
        if (other.getBucket() == null ^ this.getBucket() == null)
            return false;
        if (other.getBucket() != null && other.getBucket().equals(this.getBucket()) == false)
            return false;
        if (other.getKey() == null ^ this.getKey() == null)
            return false;
        if (other.getKey() != null && other.getKey().equals(this.getKey()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBucket() == null) ? 0 : getBucket().hashCode());
        hashCode = prime * hashCode + ((getKey() == null) ? 0 : getKey().hashCode());
        return hashCode;
    }

    @Override
    public S3InputFileLocation clone() {
        try {
            return (S3InputFileLocation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.transfer.model.transform.S3InputFileLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
