/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftdataapi.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The SQL statement to run.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/StatementData" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StatementData implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     */
    private String id;
    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     */
    private Boolean isBatchStatement;
    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     */
    private java.util.List<SqlParameter> queryParameters;
    /**
     * <p>
     * The SQL statement.
     * </p>
     */
    private String queryString;
    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     */
    private java.util.List<String> queryStrings;
    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     */
    private String secretArn;
    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     */
    private String statementName;
    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     */
    private java.util.Date updatedAt;

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) the statement was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @return The date and time (UTC) the statement was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @param createdAt
     *        The date and time (UTC) the statement was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @param id
     *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *        Redshift Data API.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @return The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *         Redshift Data API.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @param id
     *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *        Redshift Data API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @param isBatchStatement
     *        A value that indicates whether the statement is a batch query request.
     */

    public void setIsBatchStatement(Boolean isBatchStatement) {
        this.isBatchStatement = isBatchStatement;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @return A value that indicates whether the statement is a batch query request.
     */

    public Boolean getIsBatchStatement() {
        return this.isBatchStatement;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @param isBatchStatement
     *        A value that indicates whether the statement is a batch query request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withIsBatchStatement(Boolean isBatchStatement) {
        setIsBatchStatement(isBatchStatement);
        return this;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @return A value that indicates whether the statement is a batch query request.
     */

    public Boolean isBatchStatement() {
        return this.isBatchStatement;
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * 
     * @return The parameters used in a SQL statement.
     */

    public java.util.List<SqlParameter> getQueryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * 
     * @param queryParameters
     *        The parameters used in a SQL statement.
     */

    public void setQueryParameters(java.util.Collection<SqlParameter> queryParameters) {
        if (queryParameters == null) {
            this.queryParameters = null;
            return;
        }

        this.queryParameters = new java.util.ArrayList<SqlParameter>(queryParameters);
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setQueryParameters(java.util.Collection)} or {@link #withQueryParameters(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param queryParameters
     *        The parameters used in a SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withQueryParameters(SqlParameter... queryParameters) {
        if (this.queryParameters == null) {
            setQueryParameters(new java.util.ArrayList<SqlParameter>(queryParameters.length));
        }
        for (SqlParameter ele : queryParameters) {
            this.queryParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * 
     * @param queryParameters
     *        The parameters used in a SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withQueryParameters(java.util.Collection<SqlParameter> queryParameters) {
        setQueryParameters(queryParameters);
        return this;
    }

    /**
     * <p>
     * The SQL statement.
     * </p>
     * 
     * @param queryString
     *        The SQL statement.
     */

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /**
     * <p>
     * The SQL statement.
     * </p>
     * 
     * @return The SQL statement.
     */

    public String getQueryString() {
        return this.queryString;
    }

    /**
     * <p>
     * The SQL statement.
     * </p>
     * 
     * @param queryString
     *        The SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withQueryString(String queryString) {
        setQueryString(queryString);
        return this;
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * 
     * @return One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *         query request.
     */

    public java.util.List<String> getQueryStrings() {
        return queryStrings;
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * 
     * @param queryStrings
     *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *        query request.
     */

    public void setQueryStrings(java.util.Collection<String> queryStrings) {
        if (queryStrings == null) {
            this.queryStrings = null;
            return;
        }

        this.queryStrings = new java.util.ArrayList<String>(queryStrings);
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setQueryStrings(java.util.Collection)} or {@link #withQueryStrings(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param queryStrings
     *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *        query request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withQueryStrings(String... queryStrings) {
        if (this.queryStrings == null) {
            setQueryStrings(new java.util.ArrayList<String>(queryStrings.length));
        }
        for (String ele : queryStrings) {
            this.queryStrings.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * 
     * @param queryStrings
     *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *        query request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withQueryStrings(java.util.Collection<String> queryStrings) {
        setQueryStrings(queryStrings);
        return this;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @param secretArn
     *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */

    public String getSecretArn() {
        return this.secretArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @param secretArn
     *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withSecretArn(String secretArn) {
        setSecretArn(secretArn);
        return this;
    }

    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     * 
     * @param statementName
     *        The name of the SQL statement.
     */

    public void setStatementName(String statementName) {
        this.statementName = statementName;
    }

    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     * 
     * @return The name of the SQL statement.
     */

    public String getStatementName() {
        return this.statementName;
    }

    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     * 
     * @param statementName
     *        The name of the SQL statement.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withStatementName(String statementName) {
        setStatementName(statementName);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatusString
     */

    public StatementData withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * 
     * @param status
     *        The status of the SQL statement. An example is the that the SQL statement finished.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StatusString
     */

    public StatementData withStatus(StatusString status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the statement metadata was last updated.
     */

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @return The date and time (UTC) that the statement metadata was last updated.
     */

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The date and time (UTC) that the statement metadata was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StatementData withUpdatedAt(java.util.Date updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getIsBatchStatement() != null)
            sb.append("IsBatchStatement: ").append(getIsBatchStatement()).append(",");
        if (getQueryParameters() != null)
            sb.append("QueryParameters: ").append(getQueryParameters()).append(",");
        if (getQueryString() != null)
            sb.append("QueryString: ").append(getQueryString()).append(",");
        if (getQueryStrings() != null)
            sb.append("QueryStrings: ").append(getQueryStrings()).append(",");
        if (getSecretArn() != null)
            sb.append("SecretArn: ").append(getSecretArn()).append(",");
        if (getStatementName() != null)
            sb.append("StatementName: ").append(getStatementName()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StatementData == false)
            return false;
        StatementData other = (StatementData) obj;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getIsBatchStatement() == null ^ this.getIsBatchStatement() == null)
            return false;
        if (other.getIsBatchStatement() != null && other.getIsBatchStatement().equals(this.getIsBatchStatement()) == false)
            return false;
        if (other.getQueryParameters() == null ^ this.getQueryParameters() == null)
            return false;
        if (other.getQueryParameters() != null && other.getQueryParameters().equals(this.getQueryParameters()) == false)
            return false;
        if (other.getQueryString() == null ^ this.getQueryString() == null)
            return false;
        if (other.getQueryString() != null && other.getQueryString().equals(this.getQueryString()) == false)
            return false;
        if (other.getQueryStrings() == null ^ this.getQueryStrings() == null)
            return false;
        if (other.getQueryStrings() != null && other.getQueryStrings().equals(this.getQueryStrings()) == false)
            return false;
        if (other.getSecretArn() == null ^ this.getSecretArn() == null)
            return false;
        if (other.getSecretArn() != null && other.getSecretArn().equals(this.getSecretArn()) == false)
            return false;
        if (other.getStatementName() == null ^ this.getStatementName() == null)
            return false;
        if (other.getStatementName() != null && other.getStatementName().equals(this.getStatementName()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getIsBatchStatement() == null) ? 0 : getIsBatchStatement().hashCode());
        hashCode = prime * hashCode + ((getQueryParameters() == null) ? 0 : getQueryParameters().hashCode());
        hashCode = prime * hashCode + ((getQueryString() == null) ? 0 : getQueryString().hashCode());
        hashCode = prime * hashCode + ((getQueryStrings() == null) ? 0 : getQueryStrings().hashCode());
        hashCode = prime * hashCode + ((getSecretArn() == null) ? 0 : getSecretArn().hashCode());
        hashCode = prime * hashCode + ((getStatementName() == null) ? 0 : getStatementName().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        return hashCode;
    }

    @Override
    public StatementData clone() {
        try {
            return (StatementData) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.redshiftdataapi.model.transform.StatementDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
