/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelbuilding;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelbuilding.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonLexModelBuilding}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLexModelBuilding implements AmazonLexModelBuilding {

    protected AbstractAmazonLexModelBuilding() {
    }

    @Override
    public CreateBotVersionResult createBotVersion(CreateBotVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIntentVersionResult createIntentVersion(CreateIntentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSlotTypeVersionResult createSlotTypeVersion(CreateSlotTypeVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotResult deleteBot(DeleteBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotAliasResult deleteBotAlias(DeleteBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotChannelAssociationResult deleteBotChannelAssociation(DeleteBotChannelAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBotVersionResult deleteBotVersion(DeleteBotVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntentResult deleteIntent(DeleteIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntentVersionResult deleteIntentVersion(DeleteIntentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSlotTypeResult deleteSlotType(DeleteSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSlotTypeVersionResult deleteSlotTypeVersion(DeleteSlotTypeVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUtterancesResult deleteUtterances(DeleteUtterancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotResult getBot(GetBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotAliasResult getBotAlias(GetBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotAliasesResult getBotAliases(GetBotAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotChannelAssociationResult getBotChannelAssociation(GetBotChannelAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotChannelAssociationsResult getBotChannelAssociations(GetBotChannelAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotVersionsResult getBotVersions(GetBotVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotsResult getBots(GetBotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBuiltinIntentResult getBuiltinIntent(GetBuiltinIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBuiltinIntentsResult getBuiltinIntents(GetBuiltinIntentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBuiltinSlotTypesResult getBuiltinSlotTypes(GetBuiltinSlotTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExportResult getExport(GetExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImportResult getImport(GetImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntentResult getIntent(GetIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntentVersionsResult getIntentVersions(GetIntentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntentsResult getIntents(GetIntentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMigrationResult getMigration(GetMigrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMigrationsResult getMigrations(GetMigrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSlotTypeResult getSlotType(GetSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSlotTypeVersionsResult getSlotTypeVersions(GetSlotTypeVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSlotTypesResult getSlotTypes(GetSlotTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUtterancesViewResult getUtterancesView(GetUtterancesViewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutBotResult putBot(PutBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutBotAliasResult putBotAlias(PutBotAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutIntentResult putIntent(PutIntentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSlotTypeResult putSlotType(PutSlotTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportResult startImport(StartImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMigrationResult startMigration(StartMigrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
