/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateIdentityProviderRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The identity provider details. The following list describes the provider detail keys for each identity provider
     * type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> (boolean) <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     */
    private java.util.Map<String, String> identityProviderDetails;
    /**
     * <p>
     * The identity provider name.
     * </p>
     */
    private String identityProviderName;
    /**
     * <p>
     * The identity provider type.
     * </p>
     */
    private String identityProviderType;
    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     */
    private String portalArn;

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token returns the result from the original
     *        successful request.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the AWS SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token returns the result from the
     *         original successful request.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the AWS SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token returns the result from the original
     *        successful request.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the AWS SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The identity provider details. The following list describes the provider detail keys for each identity provider
     * type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> (boolean) <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The identity provider details. The following list describes the provider detail keys for each identity
     *         provider type. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Google and Login with Amazon:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Facebook:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>api_version</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Sign in with Apple:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>team_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private_key</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For OIDC providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_request_method</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oidc_issuer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *         key</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For SAML providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MetadataFile</code> OR <code>MetadataURL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IDPSignout</code> (boolean) <i>optional</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */

    public java.util.Map<String, String> getIdentityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The identity provider details. The following list describes the provider detail keys for each identity provider
     * type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> (boolean) <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @param identityProviderDetails
     *        The identity provider details. The following list describes the provider detail keys for each identity
     *        provider type. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        For Google and Login with Amazon:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For Facebook:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>api_version</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For Sign in with Apple:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>team_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>key_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>private_key</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For OIDC providers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>attributes_request_method</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>oidc_issuer</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For SAML providers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>MetadataFile</code> OR <code>MetadataURL</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>IDPSignout</code> (boolean) <i>optional</i>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     */

    public void setIdentityProviderDetails(java.util.Map<String, String> identityProviderDetails) {
        this.identityProviderDetails = identityProviderDetails;
    }

    /**
     * <p>
     * The identity provider details. The following list describes the provider detail keys for each identity provider
     * type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> (boolean) <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @param identityProviderDetails
     *        The identity provider details. The following list describes the provider detail keys for each identity
     *        provider type. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        For Google and Login with Amazon:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For Facebook:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>api_version</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For Sign in with Apple:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>team_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>key_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>private_key</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For OIDC providers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>client_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>client_secret</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>attributes_request_method</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>oidc_issuer</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_scopes</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>authorize_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>token_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>attributes_url</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code>
     *        key</i>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>jwks_uri</code> <i>if not available from discovery URL specified by <code>oidc_issuer</code> key</i>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        For SAML providers:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>MetadataFile</code> OR <code>MetadataURL</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>IDPSignout</code> (boolean) <i>optional</i>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest withIdentityProviderDetails(java.util.Map<String, String> identityProviderDetails) {
        setIdentityProviderDetails(identityProviderDetails);
        return this;
    }

    /**
     * Add a single IdentityProviderDetails entry
     *
     * @see CreateIdentityProviderRequest#withIdentityProviderDetails
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest addIdentityProviderDetailsEntry(String key, String value) {
        if (null == this.identityProviderDetails) {
            this.identityProviderDetails = new java.util.HashMap<String, String>();
        }
        if (this.identityProviderDetails.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.identityProviderDetails.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into IdentityProviderDetails.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest clearIdentityProviderDetailsEntries() {
        this.identityProviderDetails = null;
        return this;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @param identityProviderName
     *        The identity provider name.
     */

    public void setIdentityProviderName(String identityProviderName) {
        this.identityProviderName = identityProviderName;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */

    public String getIdentityProviderName() {
        return this.identityProviderName;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @param identityProviderName
     *        The identity provider name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest withIdentityProviderName(String identityProviderName) {
        setIdentityProviderName(identityProviderName);
        return this;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * 
     * @param identityProviderType
     *        The identity provider type.
     * @see IdentityProviderType
     */

    public void setIdentityProviderType(String identityProviderType) {
        this.identityProviderType = identityProviderType;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderType
     */

    public String getIdentityProviderType() {
        return this.identityProviderType;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * 
     * @param identityProviderType
     *        The identity provider type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IdentityProviderType
     */

    public CreateIdentityProviderRequest withIdentityProviderType(String identityProviderType) {
        setIdentityProviderType(identityProviderType);
        return this;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * 
     * @param identityProviderType
     *        The identity provider type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IdentityProviderType
     */

    public CreateIdentityProviderRequest withIdentityProviderType(IdentityProviderType identityProviderType) {
        this.identityProviderType = identityProviderType.toString();
        return this;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @param portalArn
     *        The ARN of the web portal.
     */

    public void setPortalArn(String portalArn) {
        this.portalArn = portalArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */

    public String getPortalArn() {
        return this.portalArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @param portalArn
     *        The ARN of the web portal.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateIdentityProviderRequest withPortalArn(String portalArn) {
        setPortalArn(portalArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getIdentityProviderDetails() != null)
            sb.append("IdentityProviderDetails: ").append("***Sensitive Data Redacted***").append(",");
        if (getIdentityProviderName() != null)
            sb.append("IdentityProviderName: ").append("***Sensitive Data Redacted***").append(",");
        if (getIdentityProviderType() != null)
            sb.append("IdentityProviderType: ").append(getIdentityProviderType()).append(",");
        if (getPortalArn() != null)
            sb.append("PortalArn: ").append(getPortalArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateIdentityProviderRequest == false)
            return false;
        CreateIdentityProviderRequest other = (CreateIdentityProviderRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getIdentityProviderDetails() == null ^ this.getIdentityProviderDetails() == null)
            return false;
        if (other.getIdentityProviderDetails() != null && other.getIdentityProviderDetails().equals(this.getIdentityProviderDetails()) == false)
            return false;
        if (other.getIdentityProviderName() == null ^ this.getIdentityProviderName() == null)
            return false;
        if (other.getIdentityProviderName() != null && other.getIdentityProviderName().equals(this.getIdentityProviderName()) == false)
            return false;
        if (other.getIdentityProviderType() == null ^ this.getIdentityProviderType() == null)
            return false;
        if (other.getIdentityProviderType() != null && other.getIdentityProviderType().equals(this.getIdentityProviderType()) == false)
            return false;
        if (other.getPortalArn() == null ^ this.getPortalArn() == null)
            return false;
        if (other.getPortalArn() != null && other.getPortalArn().equals(this.getPortalArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getIdentityProviderDetails() == null) ? 0 : getIdentityProviderDetails().hashCode());
        hashCode = prime * hashCode + ((getIdentityProviderName() == null) ? 0 : getIdentityProviderName().hashCode());
        hashCode = prime * hashCode + ((getIdentityProviderType() == null) ? 0 : getIdentityProviderType().hashCode());
        hashCode = prime * hashCode + ((getPortalArn() == null) ? 0 : getPortalArn().hashCode());
        return hashCode;
    }

    @Override
    public CreateIdentityProviderRequest clone() {
        return (CreateIdentityProviderRequest) super.clone();
    }

}
