/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.synthetics.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.synthetics.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateCanaryRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateCanaryRequestMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> CODE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Code").build();
    private static final MarshallingInfo<String> EXECUTIONROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionRoleArn").build();
    private static final MarshallingInfo<String> RUNTIMEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuntimeVersion").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").build();
    private static final MarshallingInfo<StructuredPojo> RUNCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunConfig").build();
    private static final MarshallingInfo<Integer> SUCCESSRETENTIONPERIODINDAYS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SuccessRetentionPeriodInDays").build();
    private static final MarshallingInfo<Integer> FAILURERETENTIONPERIODINDAYS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureRetentionPeriodInDays").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<StructuredPojo> VISUALREFERENCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualReference").build();
    private static final MarshallingInfo<String> ARTIFACTS3LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArtifactS3Location").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArtifactConfig").build();

    private static final UpdateCanaryRequestMarshaller instance = new UpdateCanaryRequestMarshaller();

    public static UpdateCanaryRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateCanaryRequest updateCanaryRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateCanaryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateCanaryRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getCode(), CODE_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getExecutionRoleArn(), EXECUTIONROLEARN_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getRuntimeVersion(), RUNTIMEVERSION_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getSchedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getRunConfig(), RUNCONFIG_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getSuccessRetentionPeriodInDays(), SUCCESSRETENTIONPERIODINDAYS_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getFailureRetentionPeriodInDays(), FAILURERETENTIONPERIODINDAYS_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getVpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getVisualReference(), VISUALREFERENCE_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getArtifactS3Location(), ARTIFACTS3LOCATION_BINDING);
            protocolMarshaller.marshall(updateCanaryRequest.getArtifactConfig(), ARTIFACTCONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
