/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DatabaseTableOutputOptions"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DatabaseTableOutputOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
     * </p>
     */
    private S3Location tempDirectory;
    /**
     * <p>
     * A prefix for the name of a table DataBrew will create in the database.
     * </p>
     */
    private String tableName;

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
     * </p>
     * 
     * @param tempDirectory
     *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate
     *        results.
     */

    public void setTempDirectory(S3Location tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
     * </p>
     * 
     * @return Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate
     *         results.
     */

    public S3Location getTempDirectory() {
        return this.tempDirectory;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
     * </p>
     * 
     * @param tempDirectory
     *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate
     *        results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DatabaseTableOutputOptions withTempDirectory(S3Location tempDirectory) {
        setTempDirectory(tempDirectory);
        return this;
    }

    /**
     * <p>
     * A prefix for the name of a table DataBrew will create in the database.
     * </p>
     * 
     * @param tableName
     *        A prefix for the name of a table DataBrew will create in the database.
     */

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * <p>
     * A prefix for the name of a table DataBrew will create in the database.
     * </p>
     * 
     * @return A prefix for the name of a table DataBrew will create in the database.
     */

    public String getTableName() {
        return this.tableName;
    }

    /**
     * <p>
     * A prefix for the name of a table DataBrew will create in the database.
     * </p>
     * 
     * @param tableName
     *        A prefix for the name of a table DataBrew will create in the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DatabaseTableOutputOptions withTableName(String tableName) {
        setTableName(tableName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTempDirectory() != null)
            sb.append("TempDirectory: ").append(getTempDirectory()).append(",");
        if (getTableName() != null)
            sb.append("TableName: ").append(getTableName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DatabaseTableOutputOptions == false)
            return false;
        DatabaseTableOutputOptions other = (DatabaseTableOutputOptions) obj;
        if (other.getTempDirectory() == null ^ this.getTempDirectory() == null)
            return false;
        if (other.getTempDirectory() != null && other.getTempDirectory().equals(this.getTempDirectory()) == false)
            return false;
        if (other.getTableName() == null ^ this.getTableName() == null)
            return false;
        if (other.getTableName() != null && other.getTableName().equals(this.getTableName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTempDirectory() == null) ? 0 : getTempDirectory().hashCode());
        hashCode = prime * hashCode + ((getTableName() == null) ? 0 : getTableName().hashCode());
        return hashCode;
    }

    @Override
    public DatabaseTableOutputOptions clone() {
        try {
            return (DatabaseTableOutputOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.gluedatabrew.model.transform.DatabaseTableOutputOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
