/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteEnvironmentConfigurationRequestMarshaller
implements Marshaller<Request<DeleteEnvironmentConfigurationRequest>, DeleteEnvironmentConfigurationRequest> {
    @Override
    public Request<DeleteEnvironmentConfigurationRequest> marshall(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        if (deleteEnvironmentConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteEnvironmentConfigurationRequest> request = new DefaultRequest<DeleteEnvironmentConfigurationRequest>(deleteEnvironmentConfigurationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DeleteEnvironmentConfiguration");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteEnvironmentConfigurationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(deleteEnvironmentConfigurationRequest.getApplicationName()));
        }
        if (deleteEnvironmentConfigurationRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(deleteEnvironmentConfigurationRequest.getEnvironmentName()));
        }
        return request;
    }
}

