/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryAsync;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryAsyncClientBuilder;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryClient;
import com.amazonaws.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.CreateApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteApplicationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteApplicationsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.GetDiscoverySummaryRequest;
import com.amazonaws.services.applicationdiscovery.model.GetDiscoverySummaryResult;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.ListServerNeighborsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListServerNeighborsResult;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.UpdateApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSApplicationDiscoveryAsyncClient
extends AWSApplicationDiscoveryClient
implements AWSApplicationDiscoveryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSApplicationDiscoveryAsyncClientBuilder asyncBuilder() {
        return AWSApplicationDiscoveryAsyncClientBuilder.standard();
    }

    AWSApplicationDiscoveryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateConfigurationItemsToApplicationResult> associateConfigurationItemsToApplicationAsync(AssociateConfigurationItemsToApplicationRequest request) {
        return this.associateConfigurationItemsToApplicationAsync(request, null);
    }

    @Override
    public Future<AssociateConfigurationItemsToApplicationResult> associateConfigurationItemsToApplicationAsync(final AssociateConfigurationItemsToApplicationRequest request, final AsyncHandler<AssociateConfigurationItemsToApplicationRequest, AssociateConfigurationItemsToApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociateConfigurationItemsToApplicationResult>(){

            @Override
            public AssociateConfigurationItemsToApplicationResult call() throws Exception {
                AssociateConfigurationItemsToApplicationResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.associateConfigurationItemsToApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.createApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(final CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.createTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationsResult> deleteApplicationsAsync(DeleteApplicationsRequest request) {
        return this.deleteApplicationsAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationsResult> deleteApplicationsAsync(final DeleteApplicationsRequest request, final AsyncHandler<DeleteApplicationsRequest, DeleteApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApplicationsResult>(){

            @Override
            public DeleteApplicationsResult call() throws Exception {
                DeleteApplicationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.deleteApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(final DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.deleteTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(DescribeAgentsRequest request) {
        return this.describeAgentsAsync(request, null);
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(final DescribeAgentsRequest request, final AsyncHandler<DescribeAgentsRequest, DescribeAgentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAgentsResult>(){

            @Override
            public DescribeAgentsResult call() throws Exception {
                DescribeAgentsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeAgents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(DescribeConfigurationsRequest request) {
        return this.describeConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(final DescribeConfigurationsRequest request, final AsyncHandler<DescribeConfigurationsRequest, DescribeConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConfigurationsResult>(){

            @Override
            public DescribeConfigurationsResult call() throws Exception {
                DescribeConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(DescribeExportConfigurationsRequest request) {
        return this.describeExportConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(final DescribeExportConfigurationsRequest request, final AsyncHandler<DescribeExportConfigurationsRequest, DescribeExportConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeExportConfigurationsResult>(){

            @Override
            public DescribeExportConfigurationsResult call() throws Exception {
                DescribeExportConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeExportConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateConfigurationItemsFromApplicationResult> disassociateConfigurationItemsFromApplicationAsync(DisassociateConfigurationItemsFromApplicationRequest request) {
        return this.disassociateConfigurationItemsFromApplicationAsync(request, null);
    }

    @Override
    public Future<DisassociateConfigurationItemsFromApplicationResult> disassociateConfigurationItemsFromApplicationAsync(final DisassociateConfigurationItemsFromApplicationRequest request, final AsyncHandler<DisassociateConfigurationItemsFromApplicationRequest, DisassociateConfigurationItemsFromApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociateConfigurationItemsFromApplicationResult>(){

            @Override
            public DisassociateConfigurationItemsFromApplicationResult call() throws Exception {
                DisassociateConfigurationItemsFromApplicationResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.disassociateConfigurationItemsFromApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(ExportConfigurationsRequest request) {
        return this.exportConfigurationsAsync(request, null);
    }

    @Override
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(final ExportConfigurationsRequest request, final AsyncHandler<ExportConfigurationsRequest, ExportConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ExportConfigurationsResult>(){

            @Override
            public ExportConfigurationsResult call() throws Exception {
                ExportConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.exportConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDiscoverySummaryResult> getDiscoverySummaryAsync(GetDiscoverySummaryRequest request) {
        return this.getDiscoverySummaryAsync(request, null);
    }

    @Override
    public Future<GetDiscoverySummaryResult> getDiscoverySummaryAsync(final GetDiscoverySummaryRequest request, final AsyncHandler<GetDiscoverySummaryRequest, GetDiscoverySummaryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDiscoverySummaryResult>(){

            @Override
            public GetDiscoverySummaryResult call() throws Exception {
                GetDiscoverySummaryResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.getDiscoverySummary(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(final ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.listConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServerNeighborsResult> listServerNeighborsAsync(ListServerNeighborsRequest request) {
        return this.listServerNeighborsAsync(request, null);
    }

    @Override
    public Future<ListServerNeighborsResult> listServerNeighborsAsync(final ListServerNeighborsRequest request, final AsyncHandler<ListServerNeighborsRequest, ListServerNeighborsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListServerNeighborsResult>(){

            @Override
            public ListServerNeighborsResult call() throws Exception {
                ListServerNeighborsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.listServerNeighbors(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(StartDataCollectionByAgentIdsRequest request) {
        return this.startDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(final StartDataCollectionByAgentIdsRequest request, final AsyncHandler<StartDataCollectionByAgentIdsRequest, StartDataCollectionByAgentIdsResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartDataCollectionByAgentIdsResult>(){

            @Override
            public StartDataCollectionByAgentIdsResult call() throws Exception {
                StartDataCollectionByAgentIdsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.startDataCollectionByAgentIds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(StopDataCollectionByAgentIdsRequest request) {
        return this.stopDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(final StopDataCollectionByAgentIdsRequest request, final AsyncHandler<StopDataCollectionByAgentIdsRequest, StopDataCollectionByAgentIdsResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopDataCollectionByAgentIdsResult>(){

            @Override
            public StopDataCollectionByAgentIdsResult call() throws Exception {
                StopDataCollectionByAgentIdsResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.stopDataCollectionByAgentIds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(final UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.updateApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

