/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateCaseRequestMarshaller
implements Marshaller<Request<CreateCaseRequest>, CreateCaseRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateCaseRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateCaseRequest> marshall(CreateCaseRequest createCaseRequest) {
        if (createCaseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCaseRequest> request = new DefaultRequest<CreateCaseRequest>(createCaseRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.CreateCase");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ccEmailAddressesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createCaseRequest.getSubject() != null) {
                jsonGenerator.writeFieldName("subject").writeValue(createCaseRequest.getSubject());
            }
            if (createCaseRequest.getServiceCode() != null) {
                jsonGenerator.writeFieldName("serviceCode").writeValue(createCaseRequest.getServiceCode());
            }
            if (createCaseRequest.getSeverityCode() != null) {
                jsonGenerator.writeFieldName("severityCode").writeValue(createCaseRequest.getSeverityCode());
            }
            if (createCaseRequest.getCategoryCode() != null) {
                jsonGenerator.writeFieldName("categoryCode").writeValue(createCaseRequest.getCategoryCode());
            }
            if (createCaseRequest.getCommunicationBody() != null) {
                jsonGenerator.writeFieldName("communicationBody").writeValue(createCaseRequest.getCommunicationBody());
            }
            if (!(ccEmailAddressesList = (SdkInternalList)createCaseRequest.getCcEmailAddresses()).isEmpty() || !ccEmailAddressesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ccEmailAddresses");
                jsonGenerator.writeStartArray();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonGenerator.writeValue(ccEmailAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createCaseRequest.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(createCaseRequest.getLanguage());
            }
            if (createCaseRequest.getIssueType() != null) {
                jsonGenerator.writeFieldName("issueType").writeValue(createCaseRequest.getIssueType());
            }
            if (createCaseRequest.getAttachmentSetId() != null) {
                jsonGenerator.writeFieldName("attachmentSetId").writeValue(createCaseRequest.getAttachmentSetId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

