/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItem;
import java.util.Map;

public class InventoryItemJsonMarshaller {
    private static InventoryItemJsonMarshaller instance;

    public void marshall(InventoryItem inventoryItem, StructuredJsonGenerator jsonGenerator) {
        if (inventoryItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList contentList;
            jsonGenerator.writeStartObject();
            if (inventoryItem.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(inventoryItem.getTypeName());
            }
            if (inventoryItem.getSchemaVersion() != null) {
                jsonGenerator.writeFieldName("SchemaVersion").writeValue(inventoryItem.getSchemaVersion());
            }
            if (inventoryItem.getCaptureTime() != null) {
                jsonGenerator.writeFieldName("CaptureTime").writeValue(inventoryItem.getCaptureTime());
            }
            if (inventoryItem.getContentHash() != null) {
                jsonGenerator.writeFieldName("ContentHash").writeValue(inventoryItem.getContentHash());
            }
            if (!(contentList = (SdkInternalList)inventoryItem.getContent()).isEmpty() || !contentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Content");
                jsonGenerator.writeStartArray();
                for (Map contentListValue : contentList) {
                    if (contentListValue == null) continue;
                    jsonGenerator.writeStartObject();
                    for (Map.Entry ContentListMapEntry : contentListValue.entrySet()) {
                        if (ContentListMapEntry.getValue() == null) continue;
                        jsonGenerator.writeFieldName((String)ContentListMapEntry.getKey());
                        jsonGenerator.writeValue((String)ContentListMapEntry.getValue());
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InventoryItemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InventoryItemJsonMarshaller();
        }
        return instance;
    }
}

