/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstancePatchStatesForPatchGroupRequest;
import com.amazonaws.services.simplesystemsmanagement.model.InstancePatchStateFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InstancePatchStateFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeInstancePatchStatesForPatchGroupRequestMarshaller
implements Marshaller<Request<DescribeInstancePatchStatesForPatchGroupRequest>, DescribeInstancePatchStatesForPatchGroupRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeInstancePatchStatesForPatchGroupRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeInstancePatchStatesForPatchGroupRequest> marshall(DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        if (describeInstancePatchStatesForPatchGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstancePatchStatesForPatchGroupRequest> request = new DefaultRequest<DescribeInstancePatchStatesForPatchGroupRequest>(describeInstancePatchStatesForPatchGroupRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeInstancePatchStatesForPatchGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeInstancePatchStatesForPatchGroupRequest.getPatchGroup() != null) {
                jsonGenerator.writeFieldName("PatchGroup").writeValue(describeInstancePatchStatesForPatchGroupRequest.getPatchGroup());
            }
            if (!(filtersList = (SdkInternalList)describeInstancePatchStatesForPatchGroupRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (InstancePatchStateFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    InstancePatchStateFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeInstancePatchStatesForPatchGroupRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeInstancePatchStatesForPatchGroupRequest.getNextToken());
            }
            if (describeInstancePatchStatesForPatchGroupRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeInstancePatchStatesForPatchGroupRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

