/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationDescription;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationOverviewJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationStatusJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InstanceAssociationOutputLocationJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;
import java.util.List;
import java.util.Map;

public class AssociationDescriptionJsonMarshaller {
    private static AssociationDescriptionJsonMarshaller instance;

    public void marshall(AssociationDescription associationDescription, StructuredJsonGenerator jsonGenerator) {
        if (associationDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList targetsList;
            Map<String, List<String>> parametersMap;
            jsonGenerator.writeStartObject();
            if (associationDescription.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(associationDescription.getName());
            }
            if (associationDescription.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(associationDescription.getInstanceId());
            }
            if (associationDescription.getDate() != null) {
                jsonGenerator.writeFieldName("Date").writeValue(associationDescription.getDate());
            }
            if (associationDescription.getLastUpdateAssociationDate() != null) {
                jsonGenerator.writeFieldName("LastUpdateAssociationDate").writeValue(associationDescription.getLastUpdateAssociationDate());
            }
            if (associationDescription.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                AssociationStatusJsonMarshaller.getInstance().marshall(associationDescription.getStatus(), jsonGenerator);
            }
            if (associationDescription.getOverview() != null) {
                jsonGenerator.writeFieldName("Overview");
                AssociationOverviewJsonMarshaller.getInstance().marshall(associationDescription.getOverview(), jsonGenerator);
            }
            if (associationDescription.getDocumentVersion() != null) {
                jsonGenerator.writeFieldName("DocumentVersion").writeValue(associationDescription.getDocumentVersion());
            }
            if ((parametersMap = associationDescription.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (associationDescription.getAssociationId() != null) {
                jsonGenerator.writeFieldName("AssociationId").writeValue(associationDescription.getAssociationId());
            }
            if (!(targetsList = (SdkInternalList)associationDescription.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (associationDescription.getScheduleExpression() != null) {
                jsonGenerator.writeFieldName("ScheduleExpression").writeValue(associationDescription.getScheduleExpression());
            }
            if (associationDescription.getOutputLocation() != null) {
                jsonGenerator.writeFieldName("OutputLocation");
                InstanceAssociationOutputLocationJsonMarshaller.getInstance().marshall(associationDescription.getOutputLocation(), jsonGenerator);
            }
            if (associationDescription.getLastExecutionDate() != null) {
                jsonGenerator.writeFieldName("LastExecutionDate").writeValue(associationDescription.getLastExecutionDate());
            }
            if (associationDescription.getLastSuccessfulExecutionDate() != null) {
                jsonGenerator.writeFieldName("LastSuccessfulExecutionDate").writeValue(associationDescription.getLastSuccessfulExecutionDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssociationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssociationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

