/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.UpdatePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdatePortfolioRequestMarshaller
implements Marshaller<Request<UpdatePortfolioRequest>, UpdatePortfolioRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdatePortfolioRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdatePortfolioRequest> marshall(UpdatePortfolioRequest updatePortfolioRequest) {
        if (updatePortfolioRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePortfolioRequest> request = new DefaultRequest<UpdatePortfolioRequest>(updatePortfolioRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.UpdatePortfolio");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> removeTagsList;
            List<Tag> addTagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updatePortfolioRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(updatePortfolioRequest.getAcceptLanguage());
            }
            if (updatePortfolioRequest.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(updatePortfolioRequest.getId());
            }
            if (updatePortfolioRequest.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(updatePortfolioRequest.getDisplayName());
            }
            if (updatePortfolioRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updatePortfolioRequest.getDescription());
            }
            if (updatePortfolioRequest.getProviderName() != null) {
                jsonGenerator.writeFieldName("ProviderName").writeValue(updatePortfolioRequest.getProviderName());
            }
            if ((addTagsList = updatePortfolioRequest.getAddTags()) != null) {
                jsonGenerator.writeFieldName("AddTags");
                jsonGenerator.writeStartArray();
                for (Tag tag : addTagsList) {
                    if (tag == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tag, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((removeTagsList = updatePortfolioRequest.getRemoveTags()) != null) {
                jsonGenerator.writeFieldName("RemoveTags");
                jsonGenerator.writeStartArray();
                for (String removeTagsListValue : removeTagsList) {
                    if (removeTagsListValue == null) continue;
                    jsonGenerator.writeValue(removeTagsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

