/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.SearchProductsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class SearchProductsRequestMarshaller
implements Marshaller<Request<SearchProductsRequest>, SearchProductsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public SearchProductsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SearchProductsRequest> marshall(SearchProductsRequest searchProductsRequest) {
        if (searchProductsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchProductsRequest> request = new DefaultRequest<SearchProductsRequest>(searchProductsRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.SearchProducts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> filtersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (searchProductsRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(searchProductsRequest.getAcceptLanguage());
            }
            if ((filtersMap = searchProductsRequest.getFilters()) != null) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> filtersMapValue : filtersMap.entrySet()) {
                    if (filtersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(filtersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String filtersMapValueList : filtersMapValue.getValue()) {
                        if (filtersMapValueList == null) continue;
                        jsonGenerator.writeValue(filtersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (searchProductsRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(searchProductsRequest.getPageSize());
            }
            if (searchProductsRequest.getSortBy() != null) {
                jsonGenerator.writeFieldName("SortBy").writeValue(searchProductsRequest.getSortBy());
            }
            if (searchProductsRequest.getSortOrder() != null) {
                jsonGenerator.writeFieldName("SortOrder").writeValue(searchProductsRequest.getSortOrder());
            }
            if (searchProductsRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(searchProductsRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

