/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsRequest;
import com.amazonaws.services.servicecatalog.model.transform.AccessLevelFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ScanProvisionedProductsRequestMarshaller
implements Marshaller<Request<ScanProvisionedProductsRequest>, ScanProvisionedProductsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ScanProvisionedProductsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ScanProvisionedProductsRequest> marshall(ScanProvisionedProductsRequest scanProvisionedProductsRequest) {
        if (scanProvisionedProductsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScanProvisionedProductsRequest> request = new DefaultRequest<ScanProvisionedProductsRequest>(scanProvisionedProductsRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ScanProvisionedProducts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (scanProvisionedProductsRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(scanProvisionedProductsRequest.getAcceptLanguage());
            }
            if (scanProvisionedProductsRequest.getAccessLevelFilter() != null) {
                jsonGenerator.writeFieldName("AccessLevelFilter");
                AccessLevelFilterJsonMarshaller.getInstance().marshall(scanProvisionedProductsRequest.getAccessLevelFilter(), jsonGenerator);
            }
            if (scanProvisionedProductsRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(scanProvisionedProductsRequest.getPageSize());
            }
            if (scanProvisionedProductsRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(scanProvisionedProductsRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

