/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.transform.ContactDetailJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RegisterDomainRequestMarshaller
implements Marshaller<Request<RegisterDomainRequest>, RegisterDomainRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RegisterDomainRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterDomainRequest> marshall(RegisterDomainRequest registerDomainRequest) {
        if (registerDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterDomainRequest> request = new DefaultRequest<RegisterDomainRequest>(registerDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.RegisterDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(registerDomainRequest.getDomainName());
            }
            if (registerDomainRequest.getIdnLangCode() != null) {
                jsonGenerator.writeFieldName("IdnLangCode").writeValue(registerDomainRequest.getIdnLangCode());
            }
            if (registerDomainRequest.getDurationInYears() != null) {
                jsonGenerator.writeFieldName("DurationInYears").writeValue(registerDomainRequest.getDurationInYears());
            }
            if (registerDomainRequest.getAutoRenew() != null) {
                jsonGenerator.writeFieldName("AutoRenew").writeValue(registerDomainRequest.getAutoRenew());
            }
            if (registerDomainRequest.getAdminContact() != null) {
                jsonGenerator.writeFieldName("AdminContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getAdminContact(), jsonGenerator);
            }
            if (registerDomainRequest.getRegistrantContact() != null) {
                jsonGenerator.writeFieldName("RegistrantContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getRegistrantContact(), jsonGenerator);
            }
            if (registerDomainRequest.getTechContact() != null) {
                jsonGenerator.writeFieldName("TechContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getTechContact(), jsonGenerator);
            }
            if (registerDomainRequest.getPrivacyProtectAdminContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectAdminContact").writeValue(registerDomainRequest.getPrivacyProtectAdminContact());
            }
            if (registerDomainRequest.getPrivacyProtectRegistrantContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectRegistrantContact").writeValue(registerDomainRequest.getPrivacyProtectRegistrantContact());
            }
            if (registerDomainRequest.getPrivacyProtectTechContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectTechContact").writeValue(registerDomainRequest.getPrivacyProtectTechContact());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

