/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.SearchFacesByImageRequest;
import com.amazonaws.services.rekognition.model.transform.ImageJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SearchFacesByImageRequestMarshaller
implements Marshaller<Request<SearchFacesByImageRequest>, SearchFacesByImageRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public SearchFacesByImageRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SearchFacesByImageRequest> marshall(SearchFacesByImageRequest searchFacesByImageRequest) {
        if (searchFacesByImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchFacesByImageRequest> request = new DefaultRequest<SearchFacesByImageRequest>(searchFacesByImageRequest, "AmazonRekognition");
        request.addHeader("X-Amz-Target", "RekognitionService.SearchFacesByImage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (searchFacesByImageRequest.getCollectionId() != null) {
                jsonGenerator.writeFieldName("CollectionId").writeValue(searchFacesByImageRequest.getCollectionId());
            }
            if (searchFacesByImageRequest.getImage() != null) {
                jsonGenerator.writeFieldName("Image");
                ImageJsonMarshaller.getInstance().marshall(searchFacesByImageRequest.getImage(), jsonGenerator);
            }
            if (searchFacesByImageRequest.getMaxFaces() != null) {
                jsonGenerator.writeFieldName("MaxFaces").writeValue(searchFacesByImageRequest.getMaxFaces());
            }
            if (searchFacesByImageRequest.getFaceMatchThreshold() != null) {
                jsonGenerator.writeFieldName("FaceMatchThreshold").writeValue(searchFacesByImageRequest.getFaceMatchThreshold().floatValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

