/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointBatchItem;
import com.amazonaws.services.pinpoint.model.EndpointBatchRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointBatchItemJsonMarshaller;
import java.util.List;

public class EndpointBatchRequestJsonMarshaller {
    private static EndpointBatchRequestJsonMarshaller instance;

    public void marshall(EndpointBatchRequest endpointBatchRequest, StructuredJsonGenerator jsonGenerator) {
        if (endpointBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<EndpointBatchItem> itemList = endpointBatchRequest.getItem();
            if (itemList != null) {
                jsonGenerator.writeFieldName("Item");
                jsonGenerator.writeStartArray();
                for (EndpointBatchItem itemListValue : itemList) {
                    if (itemListValue == null) continue;
                    EndpointBatchItemJsonMarshaller.getInstance().marshall(itemListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EndpointBatchRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointBatchRequestJsonMarshaller();
        }
        return instance;
    }
}

