/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DeleteInstanceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteInstanceRequestMarshaller
implements Marshaller<Request<DeleteInstanceRequest>, DeleteInstanceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteInstanceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteInstanceRequest> marshall(DeleteInstanceRequest deleteInstanceRequest) {
        if (deleteInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteInstanceRequest> request = new DefaultRequest<DeleteInstanceRequest>(deleteInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DeleteInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteInstanceRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(deleteInstanceRequest.getInstanceId());
            }
            if (deleteInstanceRequest.getDeleteElasticIp() != null) {
                jsonGenerator.writeFieldName("DeleteElasticIp").writeValue(deleteInstanceRequest.getDeleteElasticIp());
            }
            if (deleteInstanceRequest.getDeleteVolumes() != null) {
                jsonGenerator.writeFieldName("DeleteVolumes").writeValue(deleteInstanceRequest.getDeleteVolumes());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

