/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.MetricTransformation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class MetricFilter
implements Serializable,
Cloneable {
    private String filterName;
    private String filterPattern;
    private SdkInternalList<MetricTransformation> metricTransformations;
    private Long creationTime;
    private String logGroupName;

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public MetricFilter withFilterName(String filterName) {
        this.setFilterName(filterName);
        return this;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public MetricFilter withFilterPattern(String filterPattern) {
        this.setFilterPattern(filterPattern);
        return this;
    }

    public List<MetricTransformation> getMetricTransformations() {
        if (this.metricTransformations == null) {
            this.metricTransformations = new SdkInternalList();
        }
        return this.metricTransformations;
    }

    public void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        if (metricTransformations == null) {
            this.metricTransformations = null;
            return;
        }
        this.metricTransformations = new SdkInternalList<MetricTransformation>(metricTransformations);
    }

    public MetricFilter withMetricTransformations(MetricTransformation ... metricTransformations) {
        if (this.metricTransformations == null) {
            this.setMetricTransformations(new SdkInternalList<MetricTransformation>(metricTransformations.length));
        }
        for (MetricTransformation ele : metricTransformations) {
            this.metricTransformations.add(ele);
        }
        return this;
    }

    public MetricFilter withMetricTransformations(Collection<MetricTransformation> metricTransformations) {
        this.setMetricTransformations(metricTransformations);
        return this;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public MetricFilter withCreationTime(Long creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public MetricFilter withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterName() != null) {
            sb.append("FilterName: ").append(this.getFilterName()).append(",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: ").append(this.getFilterPattern()).append(",");
        }
        if (this.getMetricTransformations() != null) {
            sb.append("MetricTransformations: ").append(this.getMetricTransformations()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter)obj;
        if (other.getFilterName() == null ^ this.getFilterName() == null) {
            return false;
        }
        if (other.getFilterName() != null && !other.getFilterName().equals(this.getFilterName())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getMetricTransformations() == null ^ this.getMetricTransformations() == null) {
            return false;
        }
        if (other.getMetricTransformations() != null && !other.getMetricTransformations().equals(this.getMetricTransformations())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        return other.getLogGroupName() == null || other.getLogGroupName().equals(this.getLogGroupName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterName() == null ? 0 : this.getFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getMetricTransformations() == null ? 0 : this.getMetricTransformations().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        return hashCode;
    }

    public MetricFilter clone() {
        try {
            return (MetricFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

