/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.DeleteDomainEntryRequest;
import com.amazonaws.services.lightsail.model.transform.DomainEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteDomainEntryRequestMarshaller
implements Marshaller<Request<DeleteDomainEntryRequest>, DeleteDomainEntryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteDomainEntryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteDomainEntryRequest> marshall(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        if (deleteDomainEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDomainEntryRequest> request = new DefaultRequest<DeleteDomainEntryRequest>(deleteDomainEntryRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.DeleteDomainEntry");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteDomainEntryRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("domainName").writeValue(deleteDomainEntryRequest.getDomainName());
            }
            if (deleteDomainEntryRequest.getDomainEntry() != null) {
                jsonGenerator.writeFieldName("domainEntry");
                DomainEntryJsonMarshaller.getInstance().marshall(deleteDomainEntryRequest.getDomainEntry(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

