/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.ListVersionsByFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListVersionsByFunctionRequestMarshaller
implements Marshaller<Request<ListVersionsByFunctionRequest>, ListVersionsByFunctionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListVersionsByFunctionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListVersionsByFunctionRequest> marshall(ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        if (listVersionsByFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListVersionsByFunctionRequest> request = new DefaultRequest<ListVersionsByFunctionRequest>(listVersionsByFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", listVersionsByFunctionRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        if (listVersionsByFunctionRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listVersionsByFunctionRequest.getMarker()));
        }
        if (listVersionsByFunctionRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listVersionsByFunctionRequest.getMaxItems()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

