/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.ImportKeyMaterialRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ImportKeyMaterialRequestMarshaller
implements Marshaller<Request<ImportKeyMaterialRequest>, ImportKeyMaterialRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ImportKeyMaterialRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ImportKeyMaterialRequest> marshall(ImportKeyMaterialRequest importKeyMaterialRequest) {
        if (importKeyMaterialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportKeyMaterialRequest> request = new DefaultRequest<ImportKeyMaterialRequest>(importKeyMaterialRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ImportKeyMaterial");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (importKeyMaterialRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(importKeyMaterialRequest.getKeyId());
            }
            if (importKeyMaterialRequest.getImportToken() != null) {
                jsonGenerator.writeFieldName("ImportToken").writeValue(importKeyMaterialRequest.getImportToken());
            }
            if (importKeyMaterialRequest.getEncryptedKeyMaterial() != null) {
                jsonGenerator.writeFieldName("EncryptedKeyMaterial").writeValue(importKeyMaterialRequest.getEncryptedKeyMaterial());
            }
            if (importKeyMaterialRequest.getValidTo() != null) {
                jsonGenerator.writeFieldName("ValidTo").writeValue(importKeyMaterialRequest.getValidTo());
            }
            if (importKeyMaterialRequest.getExpirationModel() != null) {
                jsonGenerator.writeFieldName("ExpirationModel").writeValue(importKeyMaterialRequest.getExpirationModel());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

