/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListApplicationsRequestMarshaller
implements Marshaller<Request<ListApplicationsRequest>, ListApplicationsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListApplicationsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListApplicationsRequest> marshall(ListApplicationsRequest listApplicationsRequest) {
        if (listApplicationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListApplicationsRequest> request = new DefaultRequest<ListApplicationsRequest>(listApplicationsRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.ListApplications");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listApplicationsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listApplicationsRequest.getLimit());
            }
            if (listApplicationsRequest.getExclusiveStartApplicationName() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartApplicationName").writeValue(listApplicationsRequest.getExclusiveStartApplicationName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

