/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentTargetFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListAssessmentTargetsRequestMarshaller
implements Marshaller<Request<ListAssessmentTargetsRequest>, ListAssessmentTargetsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAssessmentTargetsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListAssessmentTargetsRequest> marshall(ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        if (listAssessmentTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAssessmentTargetsRequest> request = new DefaultRequest<ListAssessmentTargetsRequest>(listAssessmentTargetsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessmentTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listAssessmentTargetsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentTargetFilterJsonMarshaller.getInstance().marshall(listAssessmentTargetsRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentTargetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentTargetsRequest.getNextToken());
            }
            if (listAssessmentTargetsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAssessmentTargetsRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

