/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.PurchaseProvisionedCapacityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class PurchaseProvisionedCapacityRequestMarshaller
implements Marshaller<Request<PurchaseProvisionedCapacityRequest>, PurchaseProvisionedCapacityRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PurchaseProvisionedCapacityRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PurchaseProvisionedCapacityRequest> marshall(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) {
        if (purchaseProvisionedCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseProvisionedCapacityRequest> request = new DefaultRequest<PurchaseProvisionedCapacityRequest>(purchaseProvisionedCapacityRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/provisioned-capacity";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", purchaseProvisionedCapacityRequest.getAccountId() == null ? "-" : purchaseProvisionedCapacityRequest.getAccountId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

