/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetJobOutputRequestMarshaller
implements Marshaller<Request<GetJobOutputRequest>, GetJobOutputRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetJobOutputRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetJobOutputRequest> marshall(GetJobOutputRequest getJobOutputRequest) {
        if (getJobOutputRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetJobOutputRequest> request = new DefaultRequest<GetJobOutputRequest>(getJobOutputRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        if (getJobOutputRequest.getRange() != null) {
            request.addHeader("Range", StringUtils.fromString(getJobOutputRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", getJobOutputRequest.getAccountId() == null ? "-" : getJobOutputRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", getJobOutputRequest.getVaultName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "jobId", getJobOutputRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

