/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DescribeJobRequestMarshaller
implements Marshaller<Request<DescribeJobRequest>, DescribeJobRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeJobRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeJobRequest> marshall(DescribeJobRequest describeJobRequest) {
        if (describeJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeJobRequest> request = new DefaultRequest<DescribeJobRequest>(describeJobRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", describeJobRequest.getAccountId() == null ? "-" : describeJobRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", describeJobRequest.getVaultName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "jobId", describeJobRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

