/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateServiceRequestMarshaller
implements Marshaller<Request<UpdateServiceRequest>, UpdateServiceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateServiceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateServiceRequest> marshall(UpdateServiceRequest updateServiceRequest) {
        if (updateServiceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateServiceRequest> request = new DefaultRequest<UpdateServiceRequest>(updateServiceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.UpdateService");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateServiceRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(updateServiceRequest.getCluster());
            }
            if (updateServiceRequest.getService() != null) {
                jsonGenerator.writeFieldName("service").writeValue(updateServiceRequest.getService());
            }
            if (updateServiceRequest.getDesiredCount() != null) {
                jsonGenerator.writeFieldName("desiredCount").writeValue(updateServiceRequest.getDesiredCount());
            }
            if (updateServiceRequest.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(updateServiceRequest.getTaskDefinition());
            }
            if (updateServiceRequest.getDeploymentConfiguration() != null) {
                jsonGenerator.writeFieldName("deploymentConfiguration");
                DeploymentConfigurationJsonMarshaller.getInstance().marshall(updateServiceRequest.getDeploymentConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

