/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StopTaskRequestMarshaller
implements Marshaller<Request<StopTaskRequest>, StopTaskRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public StopTaskRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StopTaskRequest> marshall(StopTaskRequest stopTaskRequest) {
        if (stopTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopTaskRequest> request = new DefaultRequest<StopTaskRequest>(stopTaskRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.StopTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (stopTaskRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(stopTaskRequest.getCluster());
            }
            if (stopTaskRequest.getTask() != null) {
                jsonGenerator.writeFieldName("task").writeValue(stopTaskRequest.getTask());
            }
            if (stopTaskRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(stopTaskRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

