/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeregisterContainerInstanceRequestMarshaller
implements Marshaller<Request<DeregisterContainerInstanceRequest>, DeregisterContainerInstanceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeregisterContainerInstanceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeregisterContainerInstanceRequest> marshall(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        if (deregisterContainerInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeregisterContainerInstanceRequest> request = new DefaultRequest<DeregisterContainerInstanceRequest>(deregisterContainerInstanceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.DeregisterContainerInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deregisterContainerInstanceRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(deregisterContainerInstanceRequest.getCluster());
            }
            if (deregisterContainerInstanceRequest.getContainerInstance() != null) {
                jsonGenerator.writeFieldName("containerInstance").writeValue(deregisterContainerInstanceRequest.getContainerInstance());
            }
            if (deregisterContainerInstanceRequest.getForce() != null) {
                jsonGenerator.writeFieldName("force").writeValue(deregisterContainerInstanceRequest.getForce());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

