/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.NetworkBinding;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Container
implements Serializable,
Cloneable {
    private String containerArn;
    private String taskArn;
    private String name;
    private String lastStatus;
    private Integer exitCode;
    private String reason;
    private SdkInternalList<NetworkBinding> networkBindings;

    public void setContainerArn(String containerArn) {
        this.containerArn = containerArn;
    }

    public String getContainerArn() {
        return this.containerArn;
    }

    public Container withContainerArn(String containerArn) {
        this.setContainerArn(containerArn);
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public Container withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Container withName(String name) {
        this.setName(name);
        return this;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Container withLastStatus(String lastStatus) {
        this.setLastStatus(lastStatus);
        return this;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public Container withExitCode(Integer exitCode) {
        this.setExitCode(exitCode);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public Container withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public List<NetworkBinding> getNetworkBindings() {
        if (this.networkBindings == null) {
            this.networkBindings = new SdkInternalList();
        }
        return this.networkBindings;
    }

    public void setNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
            return;
        }
        this.networkBindings = new SdkInternalList<NetworkBinding>(networkBindings);
    }

    public Container withNetworkBindings(NetworkBinding ... networkBindings) {
        if (this.networkBindings == null) {
            this.setNetworkBindings(new SdkInternalList<NetworkBinding>(networkBindings.length));
        }
        for (NetworkBinding ele : networkBindings) {
            this.networkBindings.add(ele);
        }
        return this;
    }

    public Container withNetworkBindings(Collection<NetworkBinding> networkBindings) {
        this.setNetworkBindings(networkBindings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerArn() != null) {
            sb.append("ContainerArn: ").append(this.getContainerArn()).append(",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: ").append(this.getLastStatus()).append(",");
        }
        if (this.getExitCode() != null) {
            sb.append("ExitCode: ").append(this.getExitCode()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason()).append(",");
        }
        if (this.getNetworkBindings() != null) {
            sb.append("NetworkBindings: ").append(this.getNetworkBindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        if (other.getContainerArn() == null ^ this.getContainerArn() == null) {
            return false;
        }
        if (other.getContainerArn() != null && !other.getContainerArn().equals(this.getContainerArn())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getExitCode() == null ^ this.getExitCode() == null) {
            return false;
        }
        if (other.getExitCode() != null && !other.getExitCode().equals(this.getExitCode())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getNetworkBindings() == null ^ this.getNetworkBindings() == null) {
            return false;
        }
        return other.getNetworkBindings() == null || other.getNetworkBindings().equals(this.getNetworkBindings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerArn() == null ? 0 : this.getContainerArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExitCode() == null ? 0 : this.getExitCode().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBindings() == null ? 0 : this.getNetworkBindings().hashCode());
        return hashCode;
    }

    public Container clone() {
        try {
            return (Container)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

